
package Album;


import java.io.*;
import java.awt.*;
import java.util.*;
import java.text.*;
/**
 * This class was generated by a SmartGuide.
 * 
 */
public class AlbumMaker extends Share.FileHandler {
protected static ResourceBundle rb = ResourceBundle.getBundle("Album.AlbumMakerBundle");
	protected File rootPath;
	protected Frame parent;
	protected CommentDialog cd;
	protected YesNoDialog ynd;
	protected String formatFile = "index.fmt";
	protected String thumbnailFormatFile = "tnail.fmt";
	protected String imageFormatFile = "image.fmt";
	protected String imagePropertyFormatFile = "property.fmt";
	protected String exifPropertyFormatFile = "exif.fmt";
	protected String formats[] = {"line","title","line","linklist","returnlink","imagetable","comment","line"};
	protected String aligns[] = {"center","center","center","center","center","center","center","center"};
	protected String thumbnail_formats[]={"thumbnail"};
	protected String thumbnail_aligns[]={"center"};
	protected String image_formats[]={"image","title","navigationbuttons","comment","exifproperty"};
	protected String image_aligns[]={"center","center","center","center","center"};
	protected String image_property_formats[]={"$width","x","$height"};
	protected String exif_property_formats[] = {"Make","Model"};
	protected int depth;
	protected long lastupdate = 0;
	protected int direction = 1;
	protected boolean IMAGE_SIZE_OPTIMIZED = false;
	protected boolean IMAGE_WIDTH_PERCENTAGE = false;
	protected boolean IMAGE_HEIGHT_PERCENTAGE = false;
	protected boolean ALBUM_OVER_WRITE = true;
	protected boolean CONFIRM_PROCESSING = false;
	protected boolean ADD_COMMENTS = false;
	protected boolean MODIFY_COMMENTS= false;
	protected boolean COMMENT_VIEW_THUMBNAIL = true;
	protected boolean SHOW_PARENT_TITLE = false;
	protected boolean CASE_SENSITIVE = true;
	protected boolean SHOW_NEIGHBORS = false;
	protected boolean EXIF_FULL_DUMP = false;
	protected boolean MAKE_THUMBNAIL = false;
	protected boolean CHECK_UPDATED_CONTENTS = true;
	protected int TABLE_COLUMN_NUMBER = 6;
	protected int TABLE_BORDER = 0;
	protected int TABLE_SPACE = 5;
	protected int SLIDE_INTERVAL=2;
	protected int IMAGE_BORDER = 2;
	protected int IMAGE_SPACE = 0;
	protected int SCREEN_WIDTH = 800;
	protected int SCREEN_HEIGHT = 600;
	protected int IMAGE_WIDTH = 0;
	protected int IMAGE_HEIGHT = 0;
	protected int THUMBNAIL_BORDER = 5;
	protected int ICON_BORDER = 5;
	protected String IMAGE_SUFFIX[] = {".jpg"};
	protected String FILE_SUFFIX[] = {".mov", ".avi"};
	protected String HTML_SUFFIX = new String(".htm");
	protected String THUMBNAIL_SUFFIX = new String(".gif");
	protected String THUMBNAIL_DIRECTORY = new String(".tn");
	protected String TEXT_SUFFIX = new String(".txt");
	protected String TITLE_SUFFIX = new String(".ttx");
	protected String RETURN_TAG;
	protected String TOP_TAG;
	protected String PREVIOUS_TAG;
	protected String NEXT_TAG;
	protected String STOP_TAG;
	protected String SLIDE_TAG;
	protected String DOWNLOAD_TAG;
	protected String IMAGE_ALIGN = new String("horizontal");

// protected Frame parentFrame = new Frame();

/**
 * This method was created by a SmartGuide.
 */
public AlbumMaker (String r) {
	rootPath = new File(r);
	if(rootPath.getName().equals(""))
		rootPath = new File(rootPath.getParent());
	 RETURN_TAG = rb.getString("ReturnString");
	 TOP_TAG = rb.getString("TopString");
	 PREVIOUS_TAG = rb.getString("PreviousImageString");
	 NEXT_TAG = rb.getString("NextImageString");
	 STOP_TAG = rb.getString("StopString");
	 SLIDE_TAG = rb.getString("SlideShowString");
	 DOWNLOAD_TAG = rb.getString("DownloadString");
}
/**
 * This method was created by a SmartGuide.
 * @param filename java.io.File
 * @param ps java.io.PrintStream
 */
public void cat(File filename,PrintStream ps) {
// FileReader fi;
DataInputStream fi;
	try{
		fi = new DataInputStream(new FileInputStream(filename.getPath()));
	}catch(FileNotFoundException e){return;}
int c = 0;
	try{
		try{
			while((c = fi.readUnsignedByte()) >= 0){
				ps.write((byte)c);
			}
		}catch(EOFException e){
		}
		ps.flush();
		fi.close();
	}catch(IOException e){
		e.printStackTrace();
	}
	return;
}

public void startParagraph(PrintStream ps, String align){
	if(align != null && !align.equals("null")){
		ps.println("<P align=\"" + align + "\">");
	}
}

public void endParagraph(PrintStream ps, String align){
	if(align != null && !align.equals("null")){
		ps.println("</P>");
	}else{
		ps.println("<BR>");
	}
}

/**
 * This method was created by a SmartGuide.
 * @return boolean
 * @param dir java.io.File
 */
protected boolean checkDirectoryConsistency(File dir) {
	int c = 0;
	for(int i = 0 ; i<IMAGE_SUFFIX.length ; i++){
		String[] files = dir.list(new SuffixFilter(IMAGE_SUFFIX[i],CASE_SENSITIVE));
		c+=files.length;
	}
String[] htmls = dir.list(new SuffixFilter(HTML_SUFFIX,CASE_SENSITIVE));
	if(c *2 +1 != htmls.length)
		return false;
	return true;
}
/**
 * This method was created by a SmartGuide.
 * @return boolean
 */
public boolean checkSuffix() {
Hashtable ht = new Hashtable();
Object ret = null;
	if(CASE_SENSITIVE){
		for(int i = 0 ; i<IMAGE_SUFFIX.length ; i++){
			ret = ht.put(IMAGE_SUFFIX[i],IMAGE_SUFFIX[i]);
			if(ret != null)
				return false;
		}
		for(int i = 0 ; i<FILE_SUFFIX.length ; i++){
			ret = ht.put(FILE_SUFFIX[i],FILE_SUFFIX[i]);
			if(ret != null)
				return false;
		}
		if(THUMBNAIL_DIRECTORY == null || THUMBNAIL_DIRECTORY.equals("")){
			ret = ht.put(THUMBNAIL_SUFFIX,THUMBNAIL_SUFFIX);
			if(ret != null)
				return false;
		}
		ret = ht.put(HTML_SUFFIX,HTML_SUFFIX);
		if(ret != null)
			return false;
		if(ADD_COMMENTS || MODIFY_COMMENTS){
			ret = ht.put(TEXT_SUFFIX,TEXT_SUFFIX);
			if(ret != null)
				return false;
			ret = ht.put(TITLE_SUFFIX,TITLE_SUFFIX);
			if(ret != null)
				return false;
		}
	}else{
		for(int i = 0 ; i<IMAGE_SUFFIX.length ; i++){
			ret = ht.put(IMAGE_SUFFIX[i].toLowerCase(),IMAGE_SUFFIX[i]);
			if(ret != null)
				return false;
		}
		for(int i = 0 ; i<FILE_SUFFIX.length ; i++){
			ret = ht.put(FILE_SUFFIX[i].toLowerCase(),FILE_SUFFIX[i]);
			if(ret != null)
				return false;
		}
		if(THUMBNAIL_DIRECTORY == null || THUMBNAIL_DIRECTORY.equals("")){
			ret = ht.put(THUMBNAIL_SUFFIX.toLowerCase(),THUMBNAIL_SUFFIX);
			if(ret != null)
				return false;
		}
		ret = ht.put(HTML_SUFFIX.toLowerCase(),HTML_SUFFIX);
		if(ret != null)
			return false;
		if(ADD_COMMENTS || MODIFY_COMMENTS){
			ret = ht.put(TEXT_SUFFIX.toLowerCase(),TEXT_SUFFIX);
			if(ret != null)
				return false;
			ret = ht.put(TITLE_SUFFIX.toLowerCase(),TITLE_SUFFIX);
			if(ret != null)
				return false;
		}
	}
	return true;
}
/**
 * This method was created by a SmartGuide.
 * @return int
 * @param dir java.io.File
 * @param filename java.lang.String
 */
public File findFile(File dir,String filename) {
String target = dir.getPath();
	for(int i=0 ; i<=depth && target!=null ; i++){
	File f = new File(target,filename);
		if(f.exists())
			return f;
		target = (new File(target)).getParent();
	}
	return null;
}
/**
 * This method was created by a SmartGuide.
 * @return int
 * @param dir java.io.File
 * @param filename java.lang.String
 */
public int findFileDepth(File dir,String filename) {
String target = dir.getPath();
	for(int i=0 ; i<=depth && target!=null ; i++){
	File f = new File(target,filename);
		if(f.exists())
			return i;
		target = (new File(target)).getParent();
	}
	return -1;
}
/**
 * This method was created by a SmartGuide.
 * @return java.lang.String
 * @param dir java.io.File
 * @param filename java.lang.String
 */
public String findFilePath(File dir,String filename) {
int d = findFileDepth(dir,filename);
	if(d>=0){
	String f = new String(filename);
		for(int i=0 ; i<d ; i++)
			f = "../" + f;
		return f;
	}
	return null;
}
/**
 * This method was created by a SmartGuide.
 * @return java.lang.String
 * @param dir java.io.File
 */
protected String getTitleString(File dir) {
File titleTextFile = new File(dir,"title" + TEXT_SUFFIX);
String titleText = dir.getName();
	if(titleTextFile.exists()){
	FileReader fi;
		try{
			fi = new FileReader(titleTextFile.getPath());
		}catch(FileNotFoundException e){return dir.getName();}
		try{
			titleText = new String("");
			int c = 0;
			while((c = fi.read()) >= 0){
				titleText += (char)c;
			}
			fi.close();
		}catch(IOException e){return titleText;}
	}
	return titleText;
}

/**
 * This method was created by a SmartGuide.
 * @return boolean
 * @param file java.io.File
 */
public boolean isImageDirectory(File file) {
	if(file.isDirectory() && !file.getName().equals(THUMBNAIL_DIRECTORY))
		return true;
	return false;
}
/**
 * main entrypoint - starts the application
 * @param args java.lang.String[]
 */
public static void main(java.lang.String[] args) {
String rootDir = null;
	if(args.length>0)
		rootDir = args[0];
	else{
	Frame f = new Frame("temp");
	FileDialog fd = new FileDialog(f,rb.getString("RootDirSelection"),FileDialog.LOAD);
		fd.setFile("");
		fd.setVisible(true);
		rootDir = fd.getDirectory();
//		System.out.println(rootDir);
	}
	if(rootDir == null){
		System.out.println(rb.getString("InvalidRootDirErr"));
		System.exit(0);
	}
AlbumMaker am = new AlbumMaker(rootDir);
File rc = null;
	if(args.length>1){
		rc = new File(args[1]);
		if(!rc.exists())
			rc = new File(rootDir, args[1]);
	}

	if(rc == null || !rc.exists()){
	Frame f = new Frame("temp");
	FileDialog fd = new FileDialog(f,rb.getString("ResourceFileSelection"),FileDialog.LOAD);
		fd.setDirectory(rootDir);
		fd.setVisible(true);
		if(fd.getFile() != null)
			rc = new File(fd.getDirectory(),fd.getFile());
	}

	if(rc != null && rc.exists())
		am.readResources(rc.getPath());
	else
		System.out.println(rb.getString("UseDefaultResources"));
		
	am.startMaking();
	System.exit(0);
}
/**
 * This method was created by a SmartGuide.
 * @param dir java.io.File
 */
public boolean makeAlbum(File dir) {
boolean updated = false;
	if(dir.lastModified() > lastupdate)
		updated = true;
	if(CHECK_UPDATED_CONTENTS)
		updated = updated | !checkDirectoryConsistency(dir);
File comment = new File(dir, "comment" + TEXT_SUFFIX);
File title = new File(dir, "title" + TEXT_SUFFIX);
	if(ADD_COMMENTS || (MODIFY_COMMENTS && (title.exists() || comment.exists()))){
		if(cd == null){
			parent = new Frame();
			cd = new CommentDialog(parent, dir , title, comment, true);
		}else
			cd.readFiles(dir, title, comment);
		cd.pack();
		cd.setVisible(true);
		direction = cd.getDirection();
		updated = true;

		if(direction < 0){
			System.out.println(rb.getString("GoingPreviousDirectory"));
			return updated;
		}
	}
	String[] name = getSortedDirectoryList(dir);;
		direction = 1;
		for(int i=0 ; i < name.length ;){
			File f = new File(dir,name[i]);
			if(f.lastModified() > lastupdate)
				updated = true;
			if(isImageDirectory(f)){
			String answer = "y";
				if(CONFIRM_PROCESSING){
					if(ADD_COMMENTS || MODIFY_COMMENTS){
						if(ynd == null)
							ynd = new YesNoDialog(parent,"" , true);
						ynd.setQuestion(rb.getString("ProcessConfirmation") + " : " + f.getPath());
						ynd.pack();
						ynd.setVisible(true);
						if(ynd.getState())
							answer = "y";
						else
							answer = "n";
					}else{
						System.out.println(rb.getString("ProcessConfirmation") + " : " + f.getPath());
						try{
							answer = (new BufferedReader(new InputStreamReader(System.in))).readLine();
						}catch(Exception e){
							e.printStackTrace();
						}
					}
				}
				if(answer.toLowerCase().startsWith("y")){
					depth+=1;
					updated = updated | makeAlbum(f);
					depth-=1;
				}else
					System.out.println(rb.getString("ProcessPassed") + " : " + f.getPath());
			}
			i+=direction;
			if(i<0){
				i=0;
				direction = 1;
			}
		}
	if(!CHECK_UPDATED_CONTENTS || updated)
		makeIndexHtml(dir);
	return updated;
}
/**
 * This method was created by a SmartGuide.
 * @param dir java.io.File
 * @param ps java.io.PrintStream
 */
protected void makeBodyTag(File dir,PrintStream ps) {
String backDrop = findFilePath(dir,"backdrop.gif");
	if(backDrop != null)
		ps.print("<BODY BACKGROUND=\"" + backDrop + "\" ");
	else
		ps.print("<BODY ");
File colorFile = findFile(dir,"color" + TEXT_SUFFIX);
	if(colorFile != null)
		cat(colorFile,ps);
	ps.println(">");
	return;
}
/**
 * This method was created by a SmartGuide.
 * @param ps java.io.PrintStream
 */
public void makeClear(PrintStream ps) {
	ps.println("<BR clear=\"all\">");
	return;
}
/**
 * This method was created by a SmartGuide.
 * @param dir java.io.File
 * @param ps java.io.PrintStream
 */
protected void makeComment(File dir, String align, PrintStream ps) {
File commentFile = new File(dir,"comment" + TEXT_SUFFIX);
	if(commentFile.exists()){
		startParagraph(ps, align);
		cat(commentFile,ps);
		endParagraph(ps, align);
	}	
	return;
}
/**
 * This method was created by a SmartGuide.
 * @param ips Album.ImagePropertySet
 * @param number int
 * @param align java.lang.String
 * @param ps java.io.PrintStream
 */
public void makeExifPropertyTable(ImagePropertySet ips, int number, String align, PrintStream ps) {
String f[] = null;
ImageProperty ip = ips.getImageProperty(number);
Exif.ExifProperty ep = ip.getExifProperty();
	if(EXIF_FULL_DUMP)
		f = ep.getAvailableNames();
	else
		f = exif_property_formats;

	if( f==null)
		return;

	if(align.equals("center")){
		ps.println("<CENTER>");
		ps.print("<TABLE ");	
	}else
		ps.print("<TABLE align=\"" + align + "\" ");
	ps.println("border=\"0\" cellspacing=\"" + Integer.toString(TABLE_SPACE) + "\" >");

	for( int i=0 ; i<f.length ; i++ ){
		if(ep.hasEntry(f[i])){
			ps.println("<TR>");
			ps.print("<TD align=\"right\">");
			ps.print(ep.getTitle(f[i]));
			ps.println("</TD>");
			ps.print("<TD align=\"left\">");
			ps.print(ep.getStringValue(f[i]));
			ps.println("</TD>");
			ps.println("</TR>");
		}
	}

	ps.println("</TABLE>");
	if(align.toLowerCase().equals("center"))
		ps.println("</CENTER>"); 
	return;
}
/**
 * This method was created by a SmartGuide.
 * @param path java.io.File
 * @param ps java.io.PrintStream
 */
protected void makeFooter(File dir,PrintStream ps) {
File footerFile = findFile(dir,"foot" + TEXT_SUFFIX);
	if(footerFile != null)
		cat(footerFile,ps);
	ps.println("</BODY>");
	ps.println("</HTML>");
	return;
}
/**
 * This method was created by a SmartGuide.
 * @param path java.io.File
 * @param ps java.io.PrintStream
 */
protected void makeHeader(File dir,PrintStream ps) {
	ps.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\">");
	ps.println("<HTML>");
	ps.println("<HEAD>");
File headerFile = findFile(dir,"head" + TEXT_SUFFIX);
	if(headerFile != null)
		cat(headerFile,ps);
	ps.println("</HEAD>");
	return;
}
/**
 * This method was created by a SmartGuide.
 * @param dir java.io.File
 * @param align java.lang.String
 * @param num int
 * @param ps java.io.PrintStream
 */
public void makeImageComment(ImagePropertySet ip, int number, String align, PrintStream ps) {
File comment = ip.getFile(number, TEXT_SUFFIX);
	if(comment != null && comment.exists()){
		startParagraph(ps, align);
		cat(comment,ps);
		endParagraph(ps, align);
	}	
	return;
}
protected void makeImageHtml(ImagePropertySet ips, int number) {
FileOutputStream fo;
PrintStream ps;
File dir = ips.getDir();
ImageProperty ip = ips.getImageProperty(number);
int width = ip.getDimension().width;
int height = ip.getDimension().height;
	if(width > 0 && IMAGE_WIDTH > 0 && !IMAGE_WIDTH_PERCENTAGE){
		height = height  *  IMAGE_WIDTH / width;
		width = IMAGE_WIDTH;
	}else if(height > 0 && IMAGE_HEIGHT > 0 && !IMAGE_HEIGHT_PERCENTAGE){
		width = width * IMAGE_HEIGHT / height;
		height = IMAGE_HEIGHT;
	}
	if(IMAGE_SIZE_OPTIMIZED){
	int div = 1;
		while(width/div > SCREEN_WIDTH)
			div +=1;
		while(height/div > SCREEN_HEIGHT)
			div+=1;
		width = width/div;
		height = height/div;
	}
String width_string = null;
String height_string = null;
String space = Integer.toString(IMAGE_SPACE);
int image_number = ips.getLength();
	
	if(IMAGE_WIDTH_PERCENTAGE){
		width_string = Integer.toString(IMAGE_WIDTH) + "%";
	}else if(IMAGE_HEIGHT_PERCENTAGE){
		height_string = Integer.toString(IMAGE_HEIGHT) + "%";
	}else{
		width_string = Integer.toString(width);
		height_string = Integer.toString(height);
	}

File comment = ips.getFile(number, TEXT_SUFFIX);
File title = ips.getFile(number, TITLE_SUFFIX);
	if(ADD_COMMENTS || (MODIFY_COMMENTS && comment.exists())){
	File tn = new File(dir,ip.getOriginalName());
		if(COMMENT_VIEW_THUMBNAIL){
		File t = new File(dir, ips.getImageProperty(number).getThumbnailName());
			if(t.exists()){
				tn = t;
				width = ip.getThumbnailDimension().width;
				height = ip.getThumbnailDimension().height;
			}
		}
		if(cd == null){
			parent = new Frame();
			cd = new CommentDialog(parent, tn , title, comment, true);
		}else
			cd.readFiles(tn, title, comment);
		cd.setImageSize(width, height);
		cd.pack();
		cd.setVisible(true);
		direction = cd.getDirection();
	}

	try{
		fo = new FileOutputStream((ips.getFile(number, HTML_SUFFIX)).getPath());
		ps = new PrintStream(fo);
	}catch(IOException e){return;}
	try{
		makeHeader(dir,ps);
		makeBodyTag(dir,ps);
		
		for(int i=0 ; i<image_formats.length ; i++){
		String align;
			if( i<image_aligns.length )
				align = image_aligns[i];
			else
				align = "center";
			if(image_formats[i].equals("image"))
				makeImageSet(ips, number, align, width_string, height_string, ps);
			else if(image_formats[i].equals("navigationbuttons"))
				makeNavigationButtons(ips,number, align, ps);
			else if(image_formats[i].equals("comment"))
				makeImageComment(ips, number, align, ps);
			else if(image_formats[i].equals("title"))
				makeImageTitle(ips, number, align, ps);
			else if(image_formats[i].equals("property"))
				makeImageProperty(ips, number, align, ps);
			else if(image_formats[i].equals("exifproperty"))
				makeExifPropertyTable(ips, number, align, ps);
			else if(image_formats[i].equals("line"))
				makeLine(dir, align, ps);
			else if(image_formats[i].equals("clear"))
				makeClear(ps);
		}
		
		ps.println("</BODY>");
		ps.println("</HTML>");
		ps.flush();
		ps.close();
		fo.close();
	}catch(IOException e){
		e.printStackTrace();
		return;
	}

	try{
		fo = new FileOutputStream((new File(dir,"slide"+ Integer.toString(number) + HTML_SUFFIX )).getPath());
		ps = new PrintStream(fo);
	}catch(IOException e){return;}
	try{
		makeHeader(dir,ps);
	String nextName = new String("");
		if(number == image_number-1)
			nextName = new String("index" + HTML_SUFFIX);
		else if(number < image_number-1)
			nextName = new String("slide" + Integer.toString(number+1) + HTML_SUFFIX);
		ps.println("<META HTTP-EQUIV=\"Refresh\" CONTENT=\"" + Integer.toString(SLIDE_INTERVAL) + ";URL=" + nextName + "\">");
		makeBodyTag(dir,ps);
		ps.println("<CENTER>");
		makeImageTag(ips, number,"center", width_string, height_string, ps);
		ps.println("<BR>");
	String stop = findFilePath(dir,"stop.gif");
		if(stop != null)
			ps.println("<A href=\"./index" + HTML_SUFFIX + "\"><IMG src=\"" + stop + "\" alt=\"" + STOP_TAG + "\" border=\"" + ICON_BORDER + "\"></A>");
		else
			ps.println("<A href=\"./index" + HTML_SUFFIX +"\">" + STOP_TAG + "</A>");
		if(number<image_number-1){
		String next = findFilePath(dir,"next.gif");
			if(next != null)
				ps.println("<A href=\"slide" + Integer.toString(number+1) + HTML_SUFFIX + "\"><IMG src=\"" + next + "\" alt=\"" + NEXT_TAG + "\" border=\"" + ICON_BORDER + "\"></A>");
			else
				ps.println("<A href=\"slide" + Integer.toString(number+1) + HTML_SUFFIX +"\">" + NEXT_TAG + "</A>");
		}
		ps.println("</CENTER>");
		ps.println("</BODY>");
		ps.println("</HTML>");
		ps.flush();
		ps.close();
		fo.close();
	}catch(IOException e){return;}

	return;
}
/**
 * This method was created by a SmartGuide.
 * @param dir java.io.File
 * @param align java.lang.String
 * @param ps java.io.PrintStream
 */
public void makeImageProperty(ImagePropertySet ips,int number, String align, PrintStream ps) {
ImageProperty ip = ips.getImageProperty(number);
	startParagraph(ps, align);
	for(int i=0 ; i<image_property_formats.length ; i++){
		if(image_property_formats[i].startsWith("$")){
			if(image_property_formats[i].equals("$width"))
				ps.print(Integer.toString(ip.getDimension().width));
			else if(image_property_formats[i].equals("$height"))
				ps.print(Integer.toString(ip.getDimension().height));
			else if(image_property_formats[i].equals("$bytesize"))
				ps.print(Long.toString(ip.getLength()));
			else if(image_property_formats[i].equals("$kbytesize"))
				ps.print(Long.toString(ip.getLength()/1024 + 1));
			else if(image_property_formats[i].equals("$mbytesize"))
				ps.print(Long.toString(ip.getLength()/1024/1024 + 1));
			else if(image_property_formats[i].equals("$space"))
				ps.print("&nbsp;");
			else if(image_property_formats[i].equals("$br"))
				ps.print("<BR>");
		}else{
			ps.print(image_property_formats[i]);
		}
	}
	endParagraph(ps, align);
	return;
}
/**
 * This method was created by a SmartGuide.
 * @param dir java.io.File
 * @param width_string java.lang.String
 * @param height_string java.lang.String
 * @param ps java.io.PrintStream
 */
public void makeImageSet(ImagePropertySet ips, int number, String align, String width_string, String height_string, PrintStream ps) {
ImageProperty ip = ips.getImageProperty(number);
	startParagraph(ps, align);
	if(SHOW_NEIGHBORS){
		if(number > 0){
			makeThumbnailTag(ips, number-1, null, ps);
			if(!IMAGE_ALIGN.equals("horizontal"))
				ps.println("<BR>");
		}
	}

	makeImageTag(ips, number, align, width_string, height_string, ps);

	if(SHOW_NEIGHBORS){
		if(number < ips.getLength() - 1){
			if(!IMAGE_ALIGN.equals("horizontal"))
				ps.println("<BR>");
			makeThumbnailTag(ips, number+1,null, ps);
		}
	}
	endParagraph(ps, align);
	return;
}

protected void makeThumbnailContents(ImagePropertySet ips, int i, PrintStream ps){
	for(int k=0 ; k<thumbnail_formats.length ; k++){
	String tn_align;
		if( k<thumbnail_aligns.length)
			tn_align = thumbnail_aligns[k];
		else
			tn_align = "CENTER";
		if(thumbnail_formats[k].equals("thumbnail"))
			makeThumbnailTag(ips, i, tn_align, ps);
		else if(thumbnail_formats[k].equals("download")){
			ImageProperty ip = ips.getImageProperty(i);
			startParagraph(ps, tn_align);
			ps.println("<A href=\"" + ip.getOriginalName() + "\">" + DOWNLOAD_TAG + "</A>"); 
			endParagraph(ps, tn_align);
		}else if(thumbnail_formats[k].equals("comment"))
			makeImageComment(ips, i, tn_align, ps);
		else if(thumbnail_formats[k].equals("title"))
			makeImageTitle(ips, i, tn_align, ps);
		else if(thumbnail_formats[k].equals("property"))
			makeImageProperty(ips, i, tn_align, ps);
		else if(thumbnail_formats[k].equals("clear"))
			makeClear(ps);
	}
}

protected void makeImageList(ImagePropertySet ips, String align, PrintStream ps) {
int image_number = ips.getLength();
	if(image_number==0)
		return;

	direction = 1;
	for(int i=0 ; i < image_number ;){
		makeImageHtml(ips, i);
		i+=direction;
		if(i < 0){
			i=0;
			direction = 1;
		}
	}
	for(int i=0 ; i < image_number ; i++){
		startParagraph(ps, align);
		makeThumbnailContents(ips, i, ps);
		endParagraph(ps, align);
	}
	return;
}

protected void makeFileList(String files[], String align, PrintStream ps) {
	if(files == null || files.length==0)
		return;

	for(int i=0 ; i < files.length ; i++){
		startParagraph(ps, align);
		ps.println("<A href=\"" + files[i] + "\">" + files[i] + "</A>");
		endParagraph(ps, align);
	}
	return;
}

protected void makeImageTable(ImagePropertySet ips, String align, PrintStream ps) {
int image_number = ips.getLength();
	if(image_number==0)
		return;

	if(align.equals("center")){
		ps.println("<CENTER>");
		ps.print("<TABLE ");	
	}else
		ps.print("<TABLE align=\"" + align + "\" ");
	ps.println("border=\"" + Integer.toString(TABLE_BORDER) + "\" cellspacing=\"" + TABLE_SPACE + "\">");
	direction = 1;
	for(int i=0 ; i < image_number ;){
		makeImageHtml(ips, i);
		i+=direction;
		if(i < 0){
			i=0;
			direction = 1;
		}
	}
	for(int i=0 ; i < image_number ;){
		ps.println("<TR>");
		for(int j=0 ; j < TABLE_COLUMN_NUMBER && i < image_number ; j++,i++){
   	          ImageProperty ip = ips.getImageProperty(i);
			// create image view pages
			ps.println("<TD align=\"center\">");
			makeThumbnailContents(ips, i, ps);
			ps.println("</TD>");
		}
		ps.println("</TR>");
	}
	ps.println("</TABLE>");
String sl =  findFilePath(ips.getDir(),"slide.gif");
	startParagraph(ps, align);
	if(sl != null)
		ps.println("<A href=\"slide"+ Integer.toString(0) + HTML_SUFFIX +"\"><IMG src=\"" + sl +  "\" alt =\"" + SLIDE_TAG + "\" border=\"" + ICON_BORDER + "\"></A>");
	else
		ps.println("<A href=\"slide"+ Integer.toString(0) + HTML_SUFFIX +"\">" + SLIDE_TAG  + "</A>");
	endParagraph(ps, align);
	if(align.toLowerCase().equals("center"))
		ps.println("</CENTER>"); 
	return;
}

protected void makeFileTable(String files[], String align, PrintStream ps) {
	if(files == null || files.length==0)
		return;

	if(align.equals("center")){
		ps.println("<CENTER>");
		ps.print("<TABLE ");	
	}else
		ps.print("<TABLE align=\"" + align + "\" ");
	ps.println("border=\"" + Integer.toString(TABLE_BORDER) + "\" cellspacing=\"" + TABLE_SPACE + "\">");
	direction = 1;
	for(int i=0 ; i < files.length ;){
		ps.println("<TR>");
		for(int j=0 ; j < TABLE_COLUMN_NUMBER && i < files.length ; j++,i++){
			ps.println("<TD align=\"center\">");
			ps.println("<A href=\"" + files[i] + "\">" + files[i] + "</A>");
			ps.println("</TD>");
		}
		ps.println("</TR>");
	}
	ps.println("</TABLE>");
	if(align.toLowerCase().equals("center"))
		ps.println("</CENTER>"); 
	return;
}

/**
 * This method was created by a SmartGuide.
 * @param dir java.io.File
 * @param width_string java.lang.String
 * @param height_string java.lang.String
 * @param ps java.io.PrintStream
 */
public void makeImageTag(ImagePropertySet ips, int number, String align, String width_string, String height_string, PrintStream ps) {
ImageProperty ip = ips.getImageProperty(number);
String title = getImageTitle(ips, number);
	ps.print("<A href=\"" + ip.getOriginalName() + "\">");
	ps.print("<IMG src=\"" + ip.getOriginalName() + "\" align=\"" + align + "\" ");
	if(width_string != null)
		ps.print("width=\"" + width_string + "\" ");
	if(height_string != null)
		ps.print("height=\"" + height_string + "\" ");
String space =  Integer.toString(IMAGE_SPACE);
	ps.print("alt=\"" + title + "\" border=\"" + Integer.toString(IMAGE_BORDER) + "\" vspace=\"" + space + "\" hspace=\"" + space + "\" align=\"middle\">");
	ps.println("</A>");
	return;
}
/**
 * This method was created by a SmartGuide.
 * @param dir java.io.File
 * @param align java.lang.String
 * @param ps java.io.PrintStream
 */
public void makeImageTitle(ImagePropertySet ip, int number, String align, PrintStream ps) {
File title = ip.getFile(number, TITLE_SUFFIX);
	if(title != null && title.exists()){
		startParagraph(ps, align);
		cat(title,ps);
		endParagraph(ps, align);
	}	
	return;
}

protected String getImageTitle(ImagePropertySet ips, int number) {
File titleTextFile = ips.getFile(number, TITLE_SUFFIX);
String titleText = new String("image");
	if(titleTextFile.exists()){
	FileReader fi;
		try{
			fi = new FileReader(titleTextFile.getPath());
		}catch(FileNotFoundException e){return ips.getImageProperty(number).getOriginalName();}
		try{
			titleText = new String("");
			int c = 0;
			while((c = fi.read()) >= 0){
				titleText += (char)c;
			}
			fi.close();
		}catch(IOException e){return titleText;}
	}
	return titleText;
}

protected void makeIndexHtml(File dir) {
try{
	if(dir.canWrite()){
		File indexHtml = new File(dir,"index"+HTML_SUFFIX);
		if(!indexHtml.exists() || ALBUM_OVER_WRITE){
			FileOutputStream fo;
			PrintStream ps;
			fo = new FileOutputStream(indexHtml.getPath());
			ps = new PrintStream(fo);
			ImagePropertySet ips[] = new ImagePropertySet[IMAGE_SUFFIX.length];
			for(int i = 0 ; i < IMAGE_SUFFIX.length ; i++){
				ips[i] = new ImagePropertySet(dir, IMAGE_SUFFIX[i], THUMBNAIL_SUFFIX, THUMBNAIL_DIRECTORY, CASE_SENSITIVE, MAKE_THUMBNAIL);
			}
			makeHeader(dir,ps);
			makeBodyTag(dir,ps);
			for(int i=0 ; i < formats.length ; i ++){
				String align;
				if(i < aligns.length)
					align = aligns[i];
				else
					align = new String("left");
				if(formats[i].equals("line"))
					makeLine(dir, align, ps);
				else if(formats[i].equals("title"))
					makeTitle(dir, align, ps);
				else if(formats[i].equals("imagetable")){
					for(int j = 0 ; j<ips.length ; j++)
						makeImageTable(ips[j], align, ps);
					for(int j=0 ; j<FILE_SUFFIX.length ; j++){
						String[] files = dir.list(new SuffixFilter(FILE_SUFFIX[j],CASE_SENSITIVE));
						makeFileTable(files, align, ps);
					}
				}else if(formats[i].equals("imagelist")){
					for(int j = 0 ; j<ips.length ; j++)
						makeImageList(ips[j], align, ps);
					for(int j=0 ; j<FILE_SUFFIX.length ; j++){
						String[] files = dir.list(new SuffixFilter(FILE_SUFFIX[j],CASE_SENSITIVE));
						makeFileList(files, align, ps);
					}
				}else if(formats[i].equals("linklist"))
					makeLinkList(dir, align, ps);
				else if(formats[i].equals("returnlink"))
					makeReturnLink(dir,align, ps);
				else if(formats[i].equals("toplink"))
					makeTopLink(dir,align, ps);
				else if(formats[i].equals("comment"))
					makeComment(dir, align, ps);
				else if(formats[i].equals("clear"))
					makeClear(ps);					
			}
			makeFooter(dir,ps);
			System.out.println(dir.getPath() + rb.getString("PageMakeSuccess"));	
			ps.flush();
			ps.close();
			fo.close();
		}else
			System.out.println(rb.getString("ProcessPassed") + " : " + dir.getPath());
	}else
		System.out.println(rb.getString("WritePermittionErr") + " : " + dir.getPath());	
}catch(IOException e){e.printStackTrace();}
	return;
}
/**
 * This method was created by a SmartGuide.
 * @param dir java.io.File
 * @param ps java.io.PrintStream
 */
protected void makeLine(File dir, String align, PrintStream ps) {
String lineImage = findFilePath(dir,"line.gif");
	if(lineImage != null){
		startParagraph(ps, align);
		ps.println("<IMG src=\"" + lineImage + "\" align=\"" + align + "\" border=\"0\"><BR>");
		endParagraph(ps, align);
	}else
		ps.println("<HR align=\"" + align + "\">");
	return;
}
/**
 * This method was created by a SmartGuide.
 * @param dir java.io.File
 * @param ps java.io.PrintStream
 */
protected void makeLinkList(File dir, String align, PrintStream ps) {
String[] name = getSortedDirectoryList(dir);
	for(int i=0 ; i < name.length ; i++){
	File f = new File(dir,name[i]);
		if(isImageDirectory(f)){
			ps.println("<H3 align=\"" + align + "\"><A href=\"" + f.getName() + "/index" + HTML_SUFFIX + "\" name=\"" + f.getName() + "\">");
		String folder = findFilePath(dir,"folder.gif");
		String title = getTitleString(f);
			if(folder != null)
				ps.println("<IMG src=\"" + folder + "\" alt=\"" + title + "\" border=\"" + ICON_BORDER + "\">");
			ps.println(title);
			ps.println("</A></H3>");
		}
	}	
	return;
}
public void makeNavigationButtons(ImagePropertySet ips, int number, String align, PrintStream ps) {
	startParagraph(ps, align);
	if(number>0){
	String prev = findFilePath(ips.getDir(),"prev.gif");
	ImageProperty pip = ips.getImageProperty(number - 1);
		if(prev != null)
			ps.println("<A href=\"" + pip.getName() + HTML_SUFFIX + "\"><IMG src=\"" + prev + "\" alt=\"" + PREVIOUS_TAG + "\" border=\"" + ICON_BORDER + "\"></A>");
		else
			ps.println("<A href=\"" + pip.getName() + HTML_SUFFIX +"\">" + PREVIOUS_TAG + "</A>");
	}
String stop = findFilePath(ips.getDir(),"stop.gif");
	if(stop != null)
		ps.println("<A href=\"./index" + HTML_SUFFIX + "\"><IMG src=\"" + stop + "\" alt=\"" + STOP_TAG + "\" border=\"" + ICON_BORDER + "\"></A>");
	else
		ps.println("<A href=\"./index" + HTML_SUFFIX +"\">" + STOP_TAG + "</A>");
	if(number<ips.getLength()-1){
	ImageProperty nip = ips.getImageProperty(number+1);
	String next = findFilePath(ips.getDir(),"next.gif");
		if(next != null)
			ps.println("<A href=\"" + nip.getName() + HTML_SUFFIX + "\"><IMG SRC=\"" + next + "\" ALT=\"" + NEXT_TAG + "\" border=\"" + ICON_BORDER + "\"></A>");
		else
			ps.println("<A href=\"" + nip.getName() + HTML_SUFFIX +"\">" + NEXT_TAG + "</A>");
	}
	endParagraph(ps, align);
	return;
}
/**
 * This method was created by a SmartGuide.
 * @param dir java.io.File
 * @param ps java.io.PrintStream
 */
protected void makeReturnLink(File dir, String align,  PrintStream ps) {
	if(dir != rootPath){
	String ret = findFilePath(dir,"return.gif");
	String title = new String("");
		if(SHOW_PARENT_TITLE)
			title = " " + getTitleString(new File(dir.getParent()));
		ps.println("<H3 align=\"" + align + "\">");
		if(ret != null)
			ps.println("<A href=\"../index" + HTML_SUFFIX + "#" + dir.getName() + "\"><IMG src=\"" + ret + "\" alt=\"" + RETURN_TAG + "\" border=\"" + ICON_BORDER + "\">"+title + "</A><BR>");
		else
			ps.println("<A href=\"../index" + HTML_SUFFIX + "#" + dir.getName() + "\">" + RETURN_TAG + title + "</A><BR>");
		ps.println("</H3>");
	}	
	return;
}
/**
 * This method was created by a SmartGuide.
 * @param dir java.io.File
 * @param ps java.io.PrintStream
 */
protected void makeTopLink(File dir, String align,  PrintStream ps) {
	if(dir != rootPath){
	String ret = findFilePath(dir,"top.gif");
	String title = new String("");
	String topfile = new String("index" + HTML_SUFFIX);
		if(SHOW_PARENT_TITLE){
		File topdir = new File(dir.getPath());
			for(int i=0 ; i<depth ; i++)
				topdir = new File(topdir.getParent());
			title = " " + getTitleString(topdir);
		}
		for(int i=0 ; i<depth ; i++)
			topfile = "../" + topfile;
		ps.println("<H3 align=\"" + align + "\">");
		if(ret != null)
			ps.println("<A href=\"" + topfile + "\"><IMG src=\"" + ret + "\" alt=\"" + TOP_TAG + "\" border=\"" + ICON_BORDER + "\">" + title + "</A><BR>");
		else
			ps.println("<A href=\"" + topfile + "\">" + TOP_TAG + title + "</A><BR>");
		ps.println("</H3>");
	}	
	return;
}
/**
 * This method was created by a SmartGuide.
 * @param ip Album.ImageProperty
 * @param number int
 * @param ps java.io.PrintStream
 */
public void makeThumbnailTag(ImagePropertySet ips, int number, String align, PrintStream ps) {
ImageProperty ip = ips.getImageProperty(number);
	if(number >=0 && number < ips.getLength()){
	File tn = new File(ips.getDir(), ip.getThumbnailName());
	String tnpath = ip.getThumbnailPath();
	Dimension tdim = ip.getThumbnailDimension();
		startParagraph(ps, align);
		if(tn.exists())
			ps.println("<A href=\"" + ip.getName()+ HTML_SUFFIX
				      + "\"><IMG src=\"" + tnpath
				      + "\" width=\"" + Integer.toString(tdim.width) + "\" height=\"" + Integer.toString(tdim.height)
				      + "\"border=\"" + THUMBNAIL_BORDER + "\" align=\"middle\"></A>");
		else
			ps.println("<A href=\"" + ip.getName()+ HTML_SUFFIX + "\">" + ip.getOriginalName() + "</A>");
		endParagraph(ps, align);
	}
	return;
}
/**
 * This method was created by a SmartGuide.
 * @param path java.io.File
 * @param ps java.io.PrintStream
 */
public void makeTitle(File dir, String align, PrintStream ps) {
File titleImageFile = new File(dir,"title.gif");
String titleString = getTitleString(dir);
	if(titleImageFile.exists()){
		ps.println("\"<IMG src=\"title.gif\" alt=\"" + titleString +"\" border=\"0\" align=\"" + align + "\">");
	}else{
		ps.println("<H2 align=\""+ align +"\">");
		ps.println(titleString + "</H2>");
	}
	return;
}
/**
 * This method was created by a SmartGuide.
 * @param filename java.lang.String
 */
public void readFormatFiles() {
Share.PropertyReader pr = new Share.PropertyReader();
String f[][] = pr.readFormatFile(new File(rootPath,formatFile));
	if(f!=null){
		if(f.length > 0){
			formats = new String[f[0].length];
			for(int i=0 ; i<f[0].length ; i++)
				formats[i] = f[0][i].toLowerCase();
			if(f.length > 1){
				aligns = new String[f[1].length];
				for(int i=0 ; i<f[1].length ; i++)
					aligns[i] = f[1][i].toLowerCase();
			}else{
				aligns = new String[formats.length];
				for(int i =0 ; i<aligns.length ; i++)
					aligns[i] = "center";
			}
		}
	}

	f = pr.readFormatFile(new File(rootPath,thumbnailFormatFile));
	if(f!=null){
		if(f.length > 0){
			thumbnail_formats = new String[f[0].length];
			for(int i=0 ; i<f[0].length ; i++)
				thumbnail_formats[i] = f[0][i].toLowerCase();
			if(f.length > 1){
				thumbnail_aligns = new String[f[1].length];
				for(int i=0 ; i<f[1].length ; i++)
					thumbnail_aligns[i] = f[1][i].toLowerCase();
			}else{
				thumbnail_aligns = new String[thumbnail_formats.length];
				for(int i =0 ; i<thumbnail_aligns.length ; i++)
					thumbnail_aligns[i] = "center";
			}
		}
	}

	f = pr.readFormatFile(new File(rootPath,imageFormatFile));
	if(f!=null){
		if(f.length > 0){
			image_formats = new String[f[0].length];
			for(int i=0 ; i<f[0].length ; i++)
				image_formats[i] = f[0][i].toLowerCase();
			if(f.length > 1){
				image_aligns = new String[f[1].length];
				for(int i=0 ; i<f[1].length ; i++)
					image_aligns[i] = f[1][i].toLowerCase();
			}else{
				image_aligns = new String[image_formats.length];
				for(int i =0 ; i<image_aligns.length ; i++)
					image_aligns[i] = "center";
			}
		}
	}

	f = pr.readFormatFile(new File(rootPath,imagePropertyFormatFile));
	if(f!=null){
		if(f.length > 0){
			image_property_formats = new String[f[0].length];
			for(int i=0 ; i<f[0].length ; i++)
				if(f[0][i].startsWith("$"))
					image_property_formats[i] = f[0][i].toLowerCase();
				else
					image_property_formats[i] = f[0][i];
		}
	}

	f = pr.readFormatFile(new File(rootPath,exifPropertyFormatFile));
	if(f!=null){
		if(f.length > 0){
		int len = 0;
			for(int i=0 ; i<f.length ; i++ ){
				len += f[i].length;
			}
			exif_property_formats = new String[len];
		int num = 0;
			for(int i=0 ; i<f.length ; i++ )
				for(int j=0; j<f[i].length ; j++ , num++)
					exif_property_formats[num] = f[i][j];
//			System.out.println(exif_property_formats.length);
		}
	}
	return;
}
/**
 * This method was created by a SmartGuide.
 * @param filename java.lang.String
 */
public void readResources(String filename) {
	Share.ResourceReader rc = new Share.ResourceReader();
		rc.readResourceFile(filename);
	String value;
		if((value = rc.getValue("table column number")) != null)
			TABLE_COLUMN_NUMBER=Integer.parseInt(value);
		if((value = rc.getValue("table border")) != null)
			TABLE_BORDER=Integer.parseInt(value);
		if((value = rc.getValue("table space")) != null)
			TABLE_SPACE=Integer.parseInt(value);
		if((value = rc.getValue("slide interval")) != null)
			SLIDE_INTERVAL=Integer.parseInt(value);
		if((value = rc.getValue("image border")) != null)
			IMAGE_BORDER=Integer.parseInt(value);
		if((value = rc.getValue("image space")) != null)
			IMAGE_SPACE=Integer.parseInt(value);
		if((value = rc.getValue("screen width")) != null)
			SCREEN_WIDTH=Integer.parseInt(value);
		if((value = rc.getValue("screen height")) != null)
			SCREEN_HEIGHT=Integer.parseInt(value);
		if((value = rc.getValue("image width")) != null){
			if(value.endsWith("%")){
				IMAGE_WIDTH_PERCENTAGE=true;
				value = value.substring(0,value.length() - 1);
			}
			IMAGE_WIDTH=Integer.parseInt(value);
		}
		if((value = rc.getValue("image height")) != null){
			if(value.endsWith("%")){
				IMAGE_HEIGHT_PERCENTAGE=true;
				value = value.substring(0,value.length() - 1);
			}
			IMAGE_HEIGHT=Integer.parseInt(value);
		}
		if((value = rc.getValue("thumbnail border")) != null)
			THUMBNAIL_BORDER=Integer.parseInt(value);
		if((value = rc.getValue("thumbnail preferred size")) != null)
			ImageProperty.THUMBNAIL_PREFERRED_SIZE=Integer.parseInt(value);
		if((value = rc.getValue("icon border")) != null)
			ICON_BORDER=Integer.parseInt(value);
		if((value = rc.getValue("image size optimized")) != null)
			IMAGE_SIZE_OPTIMIZED=(new Boolean(value)).booleanValue();
		if((value = rc.getValue("album over write")) != null)
			ALBUM_OVER_WRITE=(new Boolean(value)).booleanValue();
		if((value = rc.getValue("add comments")) != null)
			ADD_COMMENTS=(new Boolean(value)).booleanValue();
		if((value = rc.getValue("modify comments")) != null)
			MODIFY_COMMENTS=(new Boolean(value)).booleanValue();
		if((value = rc.getValue("comment view thumbnail")) != null)
			COMMENT_VIEW_THUMBNAIL=(new Boolean(value)).booleanValue();
		if((value = rc.getValue("confirm processing")) != null)
			CONFIRM_PROCESSING=(new Boolean(value)).booleanValue();
		if((value = rc.getValue("show parent title")) != null)
			SHOW_PARENT_TITLE=(new Boolean(value)).booleanValue();
		if((value = rc.getValue("case sensitive")) != null)
			CASE_SENSITIVE=(new Boolean(value)).booleanValue();
		if((value = rc.getValue("show neighbors")) != null)
			SHOW_NEIGHBORS=(new Boolean(value)).booleanValue();
		if((value = rc.getValue("Exif full dump")) != null)
			EXIF_FULL_DUMP=(new Boolean(value)).booleanValue();
		if((value = rc.getValue("make thumbnail")) != null)
			MAKE_THUMBNAIL=(new Boolean(value)).booleanValue();
		if((value = rc.getValue("check updated contents")) != null)
			CHECK_UPDATED_CONTENTS=(new Boolean(value)).booleanValue();
		if((value = rc.getValue("image suffix")) != null){
			StringTokenizer tk = new StringTokenizer(value, ",");
			Vector vt = new Vector();
			while(tk.hasMoreTokens()){
				vt.addElement(tk.nextToken().trim());
			}
			IMAGE_SUFFIX = new String[vt.size()];
			vt.copyInto(IMAGE_SUFFIX);
		}
		if((value = rc.getValue("file suffix")) != null){
			StringTokenizer tk = new StringTokenizer(value, ",");
			Vector vt = new Vector();
			while(tk.hasMoreTokens()){
				vt.addElement(tk.nextToken().trim());
			}
			FILE_SUFFIX = new String[vt.size()];
			vt.copyInto(FILE_SUFFIX);
		}
		if((value = rc.getValue("thumbnail suffix")) != null)
			THUMBNAIL_SUFFIX = value;
		if((value = rc.getValue("thumbnail directory")) != null)
			THUMBNAIL_DIRECTORY = value;
		if((value = rc.getValue("text suffix")) != null)
			TEXT_SUFFIX = value;
		if((value = rc.getValue("html suffix")) != null)
			HTML_SUFFIX = value;
		if((value = rc.getValue("title suffix")) != null)
			TITLE_SUFFIX = value;
		if((value = rc.getValue("return tag")) != null)
			RETURN_TAG = value;
		if((value = rc.getValue("top tag")) != null)
			TOP_TAG = value;
		if((value = rc.getValue("previous tag")) != null)
			PREVIOUS_TAG = value;
		if((value = rc.getValue("next tag")) != null)
			NEXT_TAG = value;
		if((value = rc.getValue("stop tag")) != null)
			STOP_TAG = value;
		if((value = rc.getValue("slide tag")) != null)
			SLIDE_TAG = value;
		if((value = rc.getValue("download tag")) != null)
			DOWNLOAD_TAG = value;
		if((value = rc.getValue("image align")) != null){
			if(value.equals("horizontal") || value.equals("vertical"))
				IMAGE_ALIGN=value;
		}
		if((value = rc.getValue("index format file")) != null)
			formatFile = value;
		if((value = rc.getValue("image format file")) != null)
			imageFormatFile = value;
		if((value = rc.getValue("thumbnail format file")) != null)
			thumbnailFormatFile = value;
		if((value = rc.getValue("image property format file")) != null)
			imagePropertyFormatFile = value;
		if((value = rc.getValue("Exif property format file")) != null)
			exifPropertyFormatFile = value;
	return;
}
/**
 * This method was created by a SmartGuide.
 */
public void startMaking() {
	if(!checkSuffix()){
		System.err.println(rb.getString("InvalidSuffixErr"));
		return;
	}
	if(rootPath.exists()){
		depth=0;
		System.out.println(rb.getString("StartMaking"));
		readFormatFiles();
	File indexHtml = new File(rootPath, "index" + HTML_SUFFIX);
		if(indexHtml.exists())
			lastupdate = indexHtml.lastModified();
		else
			lastupdate = 0;
		makeAlbum(rootPath);
		System.out.println(rb.getString("EndMaking"));
	}else
		System.out.println(rb.getString("FileNotFound") + rootPath.getPath());	
	return;
}

}