
package Album;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
/**
 * This class was generated by a SmartGuide.
 * 
 */
public class CommentDialog extends Dialog implements ActionListener, KeyListener{
protected static ResourceBundle rb = ResourceBundle.getBundle("Album.CommentDialogBundle");
protected File imageFile;
protected File titleFile;
protected File commentFile;
protected Button Next;
protected Button Prev;
protected Button Reset;
protected TextField titleField;
protected TextArea commentArea;
protected ImageCanvas canvas;
protected int direction = 1;
protected int spaceWidth = 7;

/**
 * This method was created by a SmartGuide.
 * @param im java.io.File
 * @param com java.io.File
 */
public CommentDialog (Frame parent, File im,File title, File com, boolean modal) {
	super(parent, "", modal);

	canvas = new ImageCanvas();
	titleField = new TextField(30);
	commentArea = new TextArea("",10,30,TextArea.SCROLLBARS_VERTICAL_ONLY);
	Next = new Button(rb.getString("Next"));
	Prev = new Button(rb.getString("Previous"));
	Reset = new Button(rb.getString("Reset"));
Label  titleLabel = new Label(rb.getString("Title"));
Label  commentLabel = new Label(rb.getString("Comment"));

GridBagLayout gbl = new GridBagLayout();
	this.setLayout(gbl);
GridBagConstraints c = new GridBagConstraints();
	c.weightx = 1.0; c.weighty = 10.0;
	c.anchor = GridBagConstraints.CENTER;
	c.insets = new Insets(3,3,3,3);

	c.fill = GridBagConstraints.BOTH;
	c.gridx = 1; c.gridy = 1;
	c.gridwidth = 3; c.gridheight = 1;
	gbl.setConstraints(canvas,c);
	this.add(canvas);

	c.weighty = 0.0;

	c.fill = GridBagConstraints.HORIZONTAL ;
	c.gridx = 1; c.gridy = 2;
	c.gridwidth = 3; c.gridheight = 1;
	gbl.setConstraints(titleLabel,c);
	this.add(titleLabel);

	c.fill = GridBagConstraints.HORIZONTAL ;
	c.gridx = 1; c.gridy = 3;
	c.gridwidth = 3; c.gridheight = 1;
	gbl.setConstraints(titleField,c);
	this.add(titleField);

	c.fill = GridBagConstraints.HORIZONTAL ;
	c.gridx = 1; c.gridy = 4;
	c.gridwidth = 3; c.gridheight = 1;
	gbl.setConstraints(commentLabel,c);
	this.add(commentLabel);

	c.weighty = 1.0;

	c.fill = GridBagConstraints.BOTH;
	c.gridx = 1; c.gridy = 5;
	c.gridwidth = 3; c.gridheight = 1;
	gbl.setConstraints(commentArea,c);
	this.add(commentArea);

	c.weighty = 0.0;

	c.anchor = GridBagConstraints.EAST;
	c.fill = GridBagConstraints.NONE;
	c.gridx = 1; c.gridy = 6;
	c.gridwidth = 1; c.gridheight = 1;
	gbl.setConstraints(Prev,c);
	this.add(Prev);

	c.anchor = GridBagConstraints.CENTER;
	c.fill = GridBagConstraints.NONE;
	c.gridx = 2; c.gridy = 6;
	c.gridwidth = 1; c.gridheight = 1;
	gbl.setConstraints(Reset,c);
	this.add(Reset);

	c.anchor = GridBagConstraints.WEST;
	c.fill = GridBagConstraints.NONE;
	c.gridx = 3; c.gridy = 6;
	c.gridwidth = 1; c.gridheight = 1;
	gbl.setConstraints(Next,c);
	this.add(Next);


	Next.addActionListener(this);
	Prev.addActionListener(this);
	Reset.addActionListener(this);

	titleField.addKeyListener(this);
	commentArea.addKeyListener(this);
	Next.addKeyListener(this);
	Prev.addKeyListener(this);
	Reset.addKeyListener(this);
	this.addKeyListener(this);

	readFiles(im, title, com);
}

public int getDirection(){
	return direction;
}

// Action Methods
public void goNext(){
	direction = 1;
	saveString(commentFile,commentArea.getText());
	saveString(titleFile, titleField.getText());
	setVisible(false);
}

public void goPrevious(){
	direction = -1;
	saveString(commentFile,commentArea.getText());
	saveString(titleFile, titleField.getText());
	setVisible(false);
}

public void doReset(){
		readFiles(imageFile, titleFile, commentFile);
}

// ActionLitener Methods
public void actionPerformed(ActionEvent e){
	if(e.getSource().equals(Next)){
		goNext();
	}if(e.getSource().equals(Prev)){
		goPrevious();
	}else if(e.getSource().equals(Reset)){
		doReset();
	}
}

// KeyListener Methods
public void keyPressed(KeyEvent e){
}

public void keyReleased(KeyEvent e){
	if((e.getModifiers() & InputEvent.CTRL_MASK) != 0){
		switch(e.getKeyCode()){
			case KeyEvent.VK_N:
			goNext();
			break;
			case KeyEvent.VK_P:
			goPrevious();
			break;
			case KeyEvent.VK_R:
			doReset();
			break;
		}
	}
}

public void keyTyped(KeyEvent e){
}

/*
public void windowActivated(WindowEvent e){}
public void windowClosed(WindowEvent e){}
public void windowClosing(WindowEvent e){}
public void windowDeactivated(WindowEvent e){}
public void windowDeiconified(WindowEvent e){}
public void windowIconified(WindowEvent e){}
public void windowOpened(WindowEvent e){}
*/

public void readFiles(File im,File title, File com) {
	imageFile = im;
	if(imageFile.isDirectory())
		setTitle(rb.getString("DirTitle") + imageFile.getName());
	else
		setTitle(rb.getString("ImgTitle") + imageFile.getName());
	titleFile = title;
	commentFile = com;

	String titleText = loadString(titleFile);
	if(titleText != null) titleText = titleText.trim();
	titleField.setText(titleText);
	commentArea.setText(loadString(commentFile));

	if(imageFile.isFile())
		canvas.setImage(imageFile.getPath());
	else
		canvas.setImage(null);
	pack();
}
/**
 * CommentDialog constructor comment.
 */
public CommentDialog(Frame parent, String title, boolean modal) {
	super(parent, title, modal);
}

/**
 * This method was created by a SmartGuide.
 * @return java.lang.String
 * @param file java.io.File
 */
public String loadString(File file) {
	if(file == null || !file.exists())
		return null;
String content = null;
FileReader fi;
	try{
		fi = new FileReader(file);
	}catch(FileNotFoundException e){return null;}
	try{
		content = new String("");
		int c = 0;
		while((c = fi.read()) >= 0){
			content += (char)c;
		}
		fi.close();
	}catch(IOException e){return null;}
	return content;
}
/**
 * This method was created by a SmartGuide.
 * @param file java.io.File
 * @param content java.lang.String
 */
public void saveString(File file, String content) {
	if(file == null || content.equals(null))
		return;
	try{
	byte byte_encoded[];
		   byte_encoded = content.getBytes(new InputStreamReader(System.in).getEncoding()); // Creating byte array encoded by specified encoding.
	FileOutputStream fo;
		fo = new FileOutputStream(file); // Opening the file.
		fo.write(byte_encoded); // Writing to the file.
		fo.close(); // Closing the file.
	}catch(Exception e){
		e.printStackTrace();
	}
	return;
}
/**
 * This method was created by a SmartGuide.
 * @param w int
 * @param h int
 */
public void setImageSize(int gw,int gh) {
int w = gw;
int h = gh;
Toolkit tk = Toolkit.getDefaultToolkit();
Dimension sc = tk.getScreenSize();
	while( w > sc.width/2 || h > sc.height/2 ){
		w = w * 4 / 5;
		h = h * 4 / 5;
	}
	canvas.setSize(w,h);
	return;
}
}