
package Album;

import java.awt.*;
import java.io.*;
/**
 * This class was generated by a SmartGuide.
 * 
 */
public class ImageCanvas extends java.awt.Canvas {
protected Image image;

/**
 * ImageCanvas constructor comment.
 */
public ImageCanvas() {
	super();
}
/**
 * This method was created by a SmartGuide.
 * @param filename java.lang.String
 */

public ImageCanvas(String filename){
	super();
	setImage(filename);
}

public void setImage(String filename){
	if(filename == null){
		image = null;
		return;
	}
Toolkit tk = Toolkit.getDefaultToolkit();
	image = tk.getImage(filename);
//	tk.prepareImage(image,-1,-1,this);
	try{
	MediaTracker mt = new MediaTracker(this);
		mt.addImage(image,0);
		mt.waitForAll();
	}catch(Exception e){
		e.printStackTrace();
	}
}

/**
 * This method was created by a SmartGuide.
 * @param g java.awt.Graphics
 */
public void paint(java.awt.Graphics g) {
	if(image != null){
	Dimension dm = this.getSize();
	Dimension p = this.getPreferredSize();
	int w = p.width;
	int h = p.height;
		g.drawImage(image,(dm.width - w)/2,(dm.height - h)/2,w,h,this);
	}
	return;
}
/**
 * This method was created by a SmartGuide.
 * @return java.awt.Dimension
 */
public Dimension getPreferredSize() {
	if(image == null){
		return new Dimension(0, 0);
	}
int w = this.getSize().width;
int h = this.getSize().height;
int iw = image.getWidth(this);
int ih = image.getHeight(this);
	if( w > iw )
		w = iw;
	if( h > ih )
		h = ih;
	if( ih > 0 && h * iw / ih < w )
		w = h * iw / ih;
	else if( iw > 0 && w * ih / iw < h)
		h = w * ih / iw;
	if(w < 100)
		w=100;
	if(h < 100)
		h=100;
	return new Dimension(w,h);
}
/**
 * This method was created by a SmartGuide.
 */
public void setImageSize() {
	if(image != null)
		setSize(image.getWidth(this), image.getHeight(this));
	else
		setSize(0,0);
	return;
}
}