
package Album;

import java.io.*;
import java.awt.*;
import java.awt.image.*;
/**
 * This class was generated by a SmartGuide.
 * 
 */
public class ImageProperty {
	public static int THUMBNAIL_PREFERRED_SIZE = 200;
	protected long length;
	protected String name_org;
	protected String name;
	protected String thumbnail_name; // file name of thumbnail
	protected String thumbnail_path; // file path (HTML format) of thumbnail
	protected Dimension image_dim;
	protected Dimension thumbnail_dim;
	protected Exif.ExifProperty exif;

/**
 * This method was created by a SmartGuide.
 * @param dir java.io.File
 * @param n java.lang.String
 * @param n_org java.lang.String
 * @param tn java.lang.String
 */
public ImageProperty (File dir, String n, String n_org ,String t, String td, boolean make_thumbnail) {
	name = n;
	name_org=n_org;
	thumbnail_name=t;
	thumbnail_path=t;
File im = new File(dir, name_org);
	image_dim = getImageSize(im);
	length = im.length();
	exif = new Exif.ExifProperty();
File tn = new File(dir,t);
File tdir = new File(dir,td);
	if(tdir.exists() && tdir.isDirectory()){
		tn  = new File(new File(dir,td), t);
		if(tn.exists()){
			thumbnail_name = td + File.separator + t; // thumbnail path (local file system format)
			thumbnail_path = td + "/" + t; // thumbnail path (HTML format)
		}
	}else{
		tn = new File(dir, t);
		if(tn.exists()){
			thumbnail_name = t; // thumbnail path (local file system format)
			thumbnail_path = t; // thumbnail path (HTML format)
		}
	}
	if(image_dim.getWidth() > 0 && image_dim.getHeight() > 0){
		boolean tn_created = false;
	File tnc = new File(new File(dir,td), name); // thumbnail file name to create
		exif.setMakeThumbnail(make_thumbnail); // set make thumbnail flag
		exif.setThumbnailNameBody(tnc.getPath()); // set thumbnail file name (w/o suffix)
		if(exif.readImageFile(im)){
			if(exif.getThumbnailName() != null){
			File tnn = new File(exif.getThumbnailName()); // get actual created thumbnail name (.jpg or .tiff)
				if(tnn.exists()){
					tn = tnn;
					thumbnail_name = td + File.separator + tn.getName(); // thumbnail path (local file system format)
					thumbnail_path = td + "/" + tn.getName(); // thumbnail path (HTML format)
					tn_created = true;
				}
			}
		}
		if(!tn_created && make_thumbnail && !im.equals(tn)){ // make thumbnail by JPEGConverter
			Share.JPEGConverter jc = new Share.JPEGConverter();
			int w = image_dim.width, h = image_dim.height;
                        if(THUMBNAIL_PREFERRED_SIZE > 0){
				while(w > THUMBNAIL_PREFERRED_SIZE && h > THUMBNAIL_PREFERRED_SIZE){
					if(w == 0 || h ==0)
						break;
					w = w/2;
					h = h/2;
				}
			}
			jc.width = w;
			jc.height = h;
			jc.quality = 0.9f;
			try{
				jc.convertFile(im.getPath(), tn.getPath());
				if(tn.exists()){
					thumbnail_name = td + File.separator + tn.getName(); // thumbnail path (local file system format)
					thumbnail_path = td + "/" + tn.getName(); // thumbnail path (HTML format)
					tn_created = true;
				}
			}catch(Exception e){
				e.printStackTrace(System.err);
			}
		}
	}
	if(thumbnail_name.equals(name_org)){
		thumbnail_dim = image_dim;
	}else{
		tn = new File(dir, thumbnail_name);
		if(tn.exists())
			thumbnail_dim = getImageSize(tn);
		else
			thumbnail_dim = new Dimension(0,0);
	}
}
/**
 * This method was created by a SmartGuide.
 * @return java.awt.Dimension
 */
public Dimension getDimension() {
	return image_dim;
}
/**
 * This method was created by a SmartGuide.
 * @return Album.ExifProperty
 */
public Exif.ExifProperty getExifProperty() {
	return exif;
}
public Dimension getImageSize(File file) {
String filename = file.getPath();
int width=-1,height=-1;
ImageSizeLoader ip = new ImageSizeLoader();
Toolkit tk = Toolkit.getDefaultToolkit();
	try{
	Image image = tk.getImage(filename);
		tk.prepareImage(image, -1, -1, ip);
		width=image.getWidth(ip);
		height=image.getHeight(ip);
		for(int i=0 ; i<10 ; i++){
			if(width != -1 && height != -1)
				break;
			int status = tk.checkImage(image, -1, -1, ip);
			if((status & (
			ImageObserver.ABORT |
			ImageObserver.ALLBITS |
			ImageObserver.ERROR
			)) != 0)
				break;
			width=image.getWidth(ip);
			height=image.getHeight(ip);
			Thread.sleep(100);
		}
		image.flush();
	}catch(Exception e){
		e.printStackTrace(System.err);
	}
	return new Dimension(width,height);
}
/**
 * This method was created by a SmartGuide.
 * @return long
 */
public long getLength() {
	return length;
}
/**
 * This method was created by a SmartGuide.
 * @return java.lang.String
 * @param n int
 */
public String getName() {
	return name;
}
/**
 * This method was created by a SmartGuide.
 * @return java.lang.String
 */
public String getOriginalName() {
	return name_org;
}
/**
 * This method was created by a SmartGuide.
 * @return java.awt.Dimension
 */
public Dimension getThumbnailDimension() {
	return thumbnail_dim;
}
/**
 * This method was created by a SmartGuide.
 * @return java.lang.String
 */
public String getThumbnailName() {
	return thumbnail_name;
}
/**
 * This method was created by a SmartGuide.
 * @return java.lang.String
 */
public String getThumbnailPath() {
	return thumbnail_path;
}
}