
package Album;

import java.io.*;
import java.awt.*;
import java.awt.*;
/**
 * This class was generated by a SmartGuide.
 * 
 */
public class ThumbnailMaker {
	protected SuffixFilter image_name_filter;
	protected File rootPath;
	protected boolean THUMBNAIL_OVER_WRITE = true;
	protected boolean THUMBNAIL_SIZE_UNITY = false;
	protected String CONVERTER_PATH;
	protected String IMAGE_SUFFIX;
	protected String THUMBNAIL_SUFFIX;
	protected int THUMBNAIL_WIDTH = 100;
	protected int THUMBNAIL_HEIGHT = 100;
	protected boolean CASE_SENSITIVE = true;

/**
 * This method was created by a SmartGuide.
 * @param r java.lang.String
 */
public ThumbnailMaker (String r) {
	rootPath = new File(r);
	CONVERTER_PATH = new String("");
	IMAGE_SUFFIX = new String(".jpg");
	THUMBNAIL_SUFFIX = new String(".gif");
}
/**
 * This method was created by a SmartGuide.
 * @return boolean
 */
public boolean checkSuffix() {
	if(CASE_SENSITIVE){
		if(IMAGE_SUFFIX.equals(THUMBNAIL_SUFFIX))
			return false;
	}else{
	String imageSuffix;
		imageSuffix = IMAGE_SUFFIX.toLowerCase();
		if(imageSuffix.equals(THUMBNAIL_SUFFIX.toLowerCase()))
			return false;
	}
	return true;
}
public Dimension getImageSize(String name) {
int width,height;
ImageSizeLoader ip = new ImageSizeLoader();
Toolkit tk = Toolkit.getDefaultToolkit();
	{
	Image image = tk.getImage(name);
		width=image.getWidth(ip);
		if(width == -1)
			ip.waitForWidth();
		height=image.getHeight(ip);
		if(height == -1)
			ip.waitForHeight();
		width = image.getWidth(ip);
		height = image.getHeight(ip);
	}
	return new Dimension(width,height);
}
public static void main(java.lang.String[] args) {
	if(args.length<1){
		System.out.println("usage: java Album.ThumbNailMaker <root path name> [<resource file name>]");
		System.exit(0);
	}
ThumbnailMaker tm = new ThumbnailMaker(args[0]);
	if(args.length>1){
	File rc = new File(args[0],args[1]);
		if(rc.exists())
			tm.readResources(rc.getPath());
	}	
	tm.startMaking();
	System.exit(0);
}
/**
 * This method was created by a SmartGuide.
 * @param dir java.lang.String
 */
protected void makeThumbnail(File dir) {
String[] image_name = dir.list(image_name_filter);
int i;	
	for(i=0 ; i < image_name.length ; i++){
	String file_name = image_name[i].substring(0,image_name[i].length()-IMAGE_SUFFIX.length()); 
	File image = new File(dir,image_name[i]);
	File thumbnail = new File(dir,file_name + THUMBNAIL_SUFFIX);
		if(!THUMBNAIL_OVER_WRITE && thumbnail.exists())
			continue;
	Runtime rt = Runtime.getRuntime();
	int width = 100,height = 100,div = 1;
		if(THUMBNAIL_SIZE_UNITY){
			width = THUMBNAIL_WIDTH;
			height = THUMBNAIL_HEIGHT;
		}else{
		Dimension dm = getImageSize(image.getPath());
			width = dm.width;
			height = dm.height;
		}
		while(width/div > THUMBNAIL_WIDTH)
			div +=1;
		while(height/div > THUMBNAIL_HEIGHT)
			div+=1;
	
		try{
		Process p = rt.exec(CONVERTER_PATH + "gbmbpp -m freq8:8:8:256 "
							+ image.getPath()
							+ " " + thumbnail.getPath());
			p.waitFor();
			p = rt.exec(CONVERTER_PATH + "gbmsize -w " + Integer.toString(width/div)
						+ " -h " + Integer.toString(height/div)
						+ " " + thumbnail.getPath());
			p.waitFor();
			System.out.println("thumbnail " + thumbnail.getPath() + " successfully processed");
		}catch(IOException e){break;}catch (InterruptedException e){break;}	
	}
String[] name = dir.list();
	for(i=0 ; i < name.length ; i++){
	File f = new File(dir,name[i]);
		if(f.isDirectory())
			makeThumbnail(f);
	}	
	return;
}
public void readResources(String filename) {
Share.ResourceReader rc = new Share.ResourceReader();
	rc.readResourceFile(filename);
String value;
	if((value = rc.getValue("thumbnail width"))!= null)
		THUMBNAIL_WIDTH=Integer.parseInt(value);
	if((value = rc.getValue("thumbnail height"))!= null)
		THUMBNAIL_HEIGHT=Integer.parseInt(value);
	if((value = rc.getValue("thumbnail over write"))!= null)
		THUMBNAIL_OVER_WRITE=(new Boolean(value)).booleanValue();
	if((value = rc.getValue("thumbnail size unity"))!= null)
		THUMBNAIL_SIZE_UNITY=(new Boolean(value)).booleanValue();
	if((value = rc.getValue("image suffix"))!= null)
		IMAGE_SUFFIX = value;
	if((value = rc.getValue("thumbnail suffix"))!= null)
		THUMBNAIL_SUFFIX = value;
	if((value = rc.getValue("converter path"))!= null)
		CONVERTER_PATH = value;
	if((value = rc.getValue("case sensitive"))!= null)
		CASE_SENSITIVE = (new Boolean(value)).booleanValue();
	return;
}
/**
 * This method was created by a SmartGuide.
 */
public void startMaking() {
	if(!checkSuffix()){
		System.err.println("error : inappropriate value for \"thumbnail suffix\"");
		System.err.println("Existing data will be overwritten.");
		return;
	}
	if(rootPath.exists()){
		image_name_filter = new SuffixFilter(IMAGE_SUFFIX, CASE_SENSITIVE);
		makeThumbnail(rootPath);
	}else
		System.out.println("Specified path " + rootPath.getName() + " does not exist.");	
	return;
}
}