
package Exif;

import java.io.*;
import java.util.*;
import java.awt.*;
/**
 * This class was generated by a SmartGuide.
 * 
 */
public class ExifProperty {
ResourceBundle rb =  ResourceBundle.getBundle("Exif.ExifPropertyBundle");
protected Hashtable tiffTags,exifTags,GPSTags;
protected Vector names;
protected boolean MAKE_THUMBNAIL = false;
// protected boolean THUMBNAIL_OVERWRITE = false;
protected String tn_body = new String("tn");
protected String tn_name;
protected String formats[];
protected String filename;

/**
 * This method was created by a SmartGuide.
 * @param tags java.util.Hashtable
 * @param key java.lang.String
 */
public void changePointerValues(Hashtable tags, String key, long c) {
	if(tags.containsKey(key)){
	Vector v =((TIFFTag)tags.get(key)).getValues();
		for(Enumeration e = v.elements(); e.hasMoreElements() ; ){
		Object o = e.nextElement();
			v.addElement(new Integer((int)((long)(((Integer)o).intValue())+c)));
			v.removeElement(o);
		}
	}
	return;
}
/**
 * This method was created by a SmartGuide.
 * @return java.lang.String
 */
public String[] getAvailableNames() {
/*
Vector v = new Vector();
	if(tiffTags != null)
		for(Enumeration e = tiffTags.keys() ; e.hasMoreElements() ;)
			v.addElement((String)e.nextElement());
	if(exifTags != null)
		for(Enumeration e = exifTags.keys() ; e.hasMoreElements() ;)
			v.addElement((String)e.nextElement());
	if(GPSTags != null)
		for(Enumeration e = GPSTags.keys() ; e.hasMoreElements() ;)
			v.addElement((String)e.nextElement());
	if(v.size() > 0){
	String names[] = new String[v.size()];
		v.copyInto(names);
		return names;
	}
*/
	if(names != null && names.size() > 0){
	String n[] = new String[names.size()];
		names.copyInto(n);
		return n;
	}
	return null;
}
/**
 * This method was created by a SmartGuide.
 * @return long
 * @param tags java.util.Hashtable
 */
public long getPointerValue(Hashtable tags, String key) {
	if(tags.containsKey(key)){
	Object o =(((TIFFTag)tags.get(key)).getValues().firstElement());
		if(o != null)
			return (long)((Integer)o).intValue();
	}
	return 0;
}
/**
 * This method was created by a SmartGuide.
 * @return java.lang.String
 * @param key java.lang.String
 */
public String getStringValue(String key) {
	if(tiffTags != null && tiffTags.containsKey(key))
		return ((TIFFTag)tiffTags.get(key)).getStringValue();
	if(exifTags != null && exifTags.containsKey(key))
		return ((ExifTag)exifTags.get(key)).getStringValue();
	if(GPSTags != null && GPSTags.containsKey(key))
		return ((GPSTag)GPSTags.get(key)).getStringValue();
	return null;
}
/**
 * This method was created by a SmartGuide.
 * @return java.lang.String
 */
public String getThumbnailName() {
	return tn_name;
}
/**
 * This method was created by a SmartGuide.
 * @return java.lang.String
 * @param key java.lang.String
 */
public String getTitle(String key) {
	if(tiffTags != null && tiffTags.containsKey(key))
		return ((TIFFTag)tiffTags.get(key)).getTitle();
	if(exifTags != null && exifTags.containsKey(key))
		return ((ExifTag)exifTags.get(key)).getTitle();
	if(GPSTags != null && GPSTags.containsKey(key))
		return ((GPSTag)GPSTags.get(key)).getTitle();
	return null;
}
/**
 * This method was created by a SmartGuide.
 * @return java.util.Vector
 * @param key java.lang.String
 */
public Vector getValues(String key) {
	if(tiffTags != null && tiffTags.containsKey(key))
		return ((TIFFTag)tiffTags.get(key)).getValues();
	if(exifTags != null && exifTags.containsKey(key))
		return ((ExifTag)exifTags.get(key)).getValues();
	if(GPSTags != null && GPSTags.containsKey(key))
		return ((GPSTag)GPSTags.get(key)).getValues();
	return null;
}
/**
 * This method was created by a SmartGuide.
 * @return boolean
 * @param key java.lang.String
 */
public boolean hasEntry(String key) {
	if(tiffTags != null && tiffTags.containsKey(key))
		return true;
	if(exifTags != null && exifTags.containsKey(key))
		return true;
	if(GPSTags != null && GPSTags.containsKey(key))
		return true;
	return false;
}
/**
 * This method was created by a SmartGuide.
 * @param args java.lang.String[]
 */
public static void main(String args[]) {
//	System.out.println(Integer.MAX_VALUE);
//	System.out.println(Long.MAX_VALUE);
Share.OptionReader op = new Share.OptionReader(args);
	if(args.length > 0){
	ExifProperty exif = new ExifProperty();
	File f = new File(args[args.length - 1]);
		exif.readImageFile(f);
		if(op.containsKey("W"))
			exif.showPropertyDialog(f.getPath(), false); // Show Exif properties on a dialog window.
		else
			exif.printProperties(System.out); // Print Exif properties to the standard output.
	}else{
		System.out.println("Exif.ExifProperty [-W] <image file name>");
	}
	System.exit(0);
}
/**
 * This method was created by a SmartGuide.
 * @param align java.lang.String
 * @param ps java.io.PrintStream
 */
public void printHTMLTable(String align, PrintStream ps) {
	if(align.equals("center")){
		ps.println("<CENTER>");
		ps.print("<TABLE ");	
	}else
		ps.print("<TABLE align=\"" + align + "\" ");
	ps.println("border=\"0\" cellspacing=\"5\" >");

	for( int i=0 ; i<formats.length ; i++ ){
		if(hasEntry(formats[i])){
			ps.println("<TR>");
			ps.print("<TD align=\"right\">");
			ps.print(getTitle(formats[i]));
			ps.println("</TD>");
			ps.print("<TD align=\"left\">");
			ps.print(getStringValue(formats[i]));
			ps.println("</TD>");
			ps.println("</TR>");
		}
	}

	ps.println("</TABLE>");
	if(align.toLowerCase().equals("center"))
		ps.println("</CENTER>"); 
	return;
}
/**
 * This method was created by a SmartGuide.
 * @param ps java.io.PrintStream
 */
public void printProperties(PrintStream ps) {
String f[] = null;
	if(formats == null)
		f = getAvailableNames();
	else
		f = formats;

	if( f==null)
		return;

	for( int i=0 ; i<f.length ; i++ ){
		if(hasEntry(f[i])){
			ps.print(getTitle(f[i]));
			ps.print(" : ");
			ps.println(getStringValue(f[i]));
		}
	}

	return;
}
/**
 * This method was created by a SmartGuide.
 * @param file java.lang.String
 */
public void readFormatFile(String file) {
Share.PropertyReader pr = new Share.PropertyReader();
String f[][] = pr.readFormatFile(new File(file));
	if(f!=null){
		if(f.length > 0){
		int len = 0;
			for(int i=0 ; i<f.length ; i++ ){
				len += f[i].length;
			}
			formats = new String[len];
		int num = 0;
			for(int i=0 ; i<f.length ; i++ )
				for(int j=0; j<f[i].length ; j++ , num++)
					formats[num] = f[i][j];
		}
	}
	return;
}
/**
 * This method was created by a SmartGuide.
 * @param filename java.io.File
 */
public boolean readImageFile(File fn) {
boolean ret = false;
	filename = fn.getPath();
	try{
	RandomAccessFile file = new RandomAccessFile(fn, "r");
		ret = readImageFile(file);
		file.close();
	}catch(java.io.IOException e){
		e.printStackTrace();
		return false;
	}	
	return ret;
}
/**
 * This method was created by a SmartGuide.
 * @param file java.io.RandomAccessFile
 */
public boolean readImageFile(RandomAccessFile file) throws java.io.IOException {
	names = new Vector(); // list of tag names
long tiffhead = 0; // position of TIFF header
long applen = 0; // JPEG APP1 length
boolean tn_compress = false; // thumbnail image compress/uncompress
boolean compress = false; // primary image compressed/uncompressed
String tn_suffix = new String("");
	file.seek(0);
int b1,b2;
	b1 = file.readUnsignedByte();
	b2 = file.readUnsignedByte();
	if (b1 == 0xff && b2 == 0xd8 ){ // JPEG file start marker
//		System.out.println("Its a JPEG file.");
		compress = true; // primary image is compressed (JPEG)
		b1 = file.readUnsignedByte();
		b2 = file.readUnsignedByte();
		if( b1 == 0xff && b2 == 0xe1 ){ // APP1 marker
//			System.out.println("APP1 marker recognized");
			b1 = file.readUnsignedByte();
			b2 = file.readUnsignedByte();
			applen = (long)b1 * 256 + (long)b2; // APP1 length
		String id = new String("");
			for(int i=0 ; i < 4 ; i++)
				id += (char)file.readUnsignedByte();
			if(!id.equals("Exif")){ // file type ID must be "Exif".
				System.err.println(rb.getString("ExifErr") + filename);
				return false;
			}
			while( (b1 = file.readUnsignedByte()) == '\0'); // skip null characters
			b2 = file.readUnsignedByte();
			tiffhead = file.getFilePointer() - 2;
//			System.out.println("TIFF header pointer : " + Long.toString(tiffhead));
		}else{
			System.err.println(rb.getString("APP1Err") + filename);
			return false;
		}
	}
	
	if ( b1 == 0x49 && b2 == 0x49 ){ // "II",TIFF file, little endian (Intel)
//		System.out.println("little endian");
		TIFFTag.setLittleEndian(true);
	}else if ( b1 == 0x4d && b2 == 0x4d ){ // "MM",TIFF file, big endian (Motorora)
//		System.out.println("big endian");
		TIFFTag.setLittleEndian(false);
	}else{
		System.err.println(rb.getString("TIFFEndianErr") + filename);
		return false;
	}
int id = TIFFTag.readWord(file);
	if( id != 0x002a ){ // TIFF file ID
		System.err.println(rb.getString("TIFFIDErr") + filename);
		return false;
	}
long offset = (long)TIFFTag.readDWord(file); // offset to 0th IFD
//	System.out.println("TIFF 0th IFD pointer : " + Long.toString(offset));
//	System.out.println("TIFF 0th IFD address : " + Long.toString(tiffhead + offset));
	TIFFTag.setHeaderPoint(tiffhead);
	file.seek(tiffhead + offset);
int num = TIFFTag.readWord(file); // read number of TIFF Tag
//	System.out.println("TIFF tag number : " + Integer.toString(num));
	tiffTags = new Hashtable();
long exifPointer = 0,GPSPointer = 0;
	for(int i=0 ; i < num ; i++){
	TIFFTag tag = new TIFFTag();
		tag.readFromFile(file, offset + 2 + i * 12);
		if(tag.getName() != null){
			tiffTags.put(tag.getName(),tag);
			names.addElement(tag.getName());
		}
	}
	exifPointer = (long)getPointerValue(tiffTags, "ExifIFDPointer");
	GPSPointer = (long)getPointerValue(tiffTags, "GPSInfoIFDPointer");

	file.seek(tiffhead + offset + 2 + num * 12);

long nextIFDPointer = (long)TIFFTag.readDWord(file); // pointer to the 1st IFD
long tnhead = 0,tnlen = 0; // thumbnail infomation
Hashtable tnTags = null;
	if(tiffhead + nextIFDPointer < 0){
		System.err.println("1st IFD Pointer error: " + nextIFDPointer);
	}else if(nextIFDPointer != 0){
		file.seek(tiffhead + nextIFDPointer);
		num = TIFFTag.readWord(file); // read number of Exif Tag
		tnTags = new Hashtable();
		for(int i=0 ; i < num ; i++){
		TIFFTag tag = new TIFFTag();
			tag.readFromFile(file, nextIFDPointer + 2 + i * 12);
			if(tag.getName() != null)
				tnTags.put(tag.getName(),tag);
		}
	long tnend = 0;
		if(compress)
			tnend = applen + 2;
		else
			tnend = getPointerValue(tiffTags, "StripOffsets");
		if(tnTags.containsKey("JPEGInterchangeFormat") && tnTags.containsKey("JPEGInterchangeFormatLength")){
//			System.out.println("compressed thumbnail");
			tn_compress = true; // thumbnail image is compressed (JPEG)
			tn_suffix = new String(".jpg");
			tnhead = tiffhead + getPointerValue(tnTags, "JPEGInterchangeFormat");
			tnlen = getPointerValue(tnTags, "JPEGInterchangeFormatLength");
		}else{
//			System.out.println("uncompressed thumbnail");
			tn_compress = false; // thumbnail image is not compressed (TIFF)
			tn_suffix = new String(".tiff");
			tnhead = tiffhead +nextIFDPointer;
			tnlen = tnend - tnhead;
		}
	}

	if(tiffTags.containsKey("ExifIFDPointer") && exifPointer <= 0){
		System.err.println("ExifIFDPointer error: " + exifPointer);
	}else if(exifPointer != 0){
		file.seek(tiffhead + exifPointer);
		num = TIFFTag.readWord(file); // read number of Exif Tag
		exifTags = new Hashtable();
		for(int i=0 ; i < num ; i++){
		ExifTag tag = new ExifTag();
			tag.readFromFile(file, exifPointer + 2 + i * 12);
			if(tag.getName() != null){
				exifTags.put(tag.getName(),tag);
				names.addElement(tag.getName());
			}
		}
	}

	if(tiffTags.containsKey("GPSInfoIFDPointer") && GPSPointer <= 0){
		System.err.println("ExifIFDPointer error: " + exifPointer);
	}else if(GPSPointer != 0){
		file.seek(tiffhead + GPSPointer);
		num = TIFFTag.readWord(file); // read number of GPS Tag
		GPSTags = new Hashtable();
		for(int i=0 ; i < num ; i++){
		GPSTag tag = new GPSTag();
			tag.readFromFile(file, GPSPointer + 2 + i * 12);
			if(tag.getName() != null){
				GPSTags.put(tag.getName(),tag);
				names.addElement(tag.getName());
			}
		}
	}

	if(MAKE_THUMBNAIL && tnhead > 0 && tnlen > 0){
		tn_name = tn_body + tn_suffix;
	File tn = new File(tn_name);
		if(!tn.exists()){ // never overwrite thumbnail file
		RandomAccessFile fo = new RandomAccessFile(tn,"rw");
			if(!tn_compress)
				TIFFTag.writeHeader(fo);
			file.seek(tnhead);
		byte b;
			for(int i=0; i<tnlen; i++){
				b = (byte)file.readUnsignedByte();
				fo.write(b); // Write to the file.
			}

			if(!tn_compress && tnTags != null){
					TIFFTag.setHeaderPoint(0);
				for(Enumeration e=tnTags.elements() ; e.hasMoreElements() ;){
				TIFFTag tnTag = (TIFFTag)e.nextElement();
					tnTag.changePoint(-nextIFDPointer + 8);
					tnTag.changeOffset(-nextIFDPointer + 8);
					tnTag.overwriteOffset(fo);
				}
				changePointerValues(tnTags, "StripOffsets", -nextIFDPointer + 8);
			TIFFTag stag = (TIFFTag)tnTags.get("StripOffsets");
				stag.overwriteValues(fo);
			}
			fo.close(); // Close the file.
		}
	}
	return true;
}
/**
 * This method was created by a SmartGuide.
 * @param t boolean
 */
public void setMakeThumbnail(boolean t) {
	MAKE_THUMBNAIL = t;
	return;
}
/**
 * This method was created by a SmartGuide.
 * @param n java.lang.String
 */
public void setThumbnailNameBody(String n) {
	tn_body = n;
	return;
}
/**
 * This method was created by a SmartGuide.
 * @param editable boolean
 */
public void showPropertyDialog(String filename, boolean editable) {
String f[] = getAvailableNames();
	if( f==null)
		return;

Hashtable sht = new Hashtable();
String n[] = new String[f.length];
	for( int i=0 ; i<f.length ; i++ ){
		if(hasEntry(f[i])){
			sht.put(getTitle(f[i]), getStringValue(f[i]));
			n[i] = getTitle(f[i]);
		}
	}
Frame parent = new Frame();
Share.HashtableEditDialog htedit = new Share.HashtableEditDialog(parent, filename,sht, n, true ,false);
	htedit.show();
	return;
}
}