
package Exif;


import java.io.*;
import java.util.*;
/**
 * This class was generated by a SmartGuide.
 * 
 */
public class TIFFTag{
// constants
protected static final int BYTE_BOUNDARY = 256;
protected static final int TYPE_BYTE = 1;
protected static final int TYPE_ASCII = 2;
protected static final int TYPE_SHORT = 3;
protected static final int TYPE_LONG = 4;
protected static final int TYPE_RATIONAL = 5;
protected static final int TYPE_UNDEFINED = 7;
protected static final int TYPE_SLONG = 9;
protected static final int TYPE_SRATIONAL = 10;
protected static final char STRING_TERMINATOR = 0x00;
public static final int EXIF_POINTER_TAG = 34665;
public static final int GPS_POINTER_TAG = 34853;
// static variables
protected static boolean LITTLE_ENDIAN = true; // endianness
protected static long HEADER_POINT = 0; // TIFF header pointer
protected static int types[] = { // tag IDs
// TIFF Rev. 6.0
	// A.
	256,257,258,259,262,274,277,284,530,531,282,283,296,
	// B.
	273,278,279,513,514,
	// C.
	301,318,319,529,532,
	// D.
	306,270,271,272,305,315,3432,
	// others
	34665,34853
	};
protected static String names[] = { // field names
// TIFF Rev. 6.0
	// A.
	"ImageWidth","ImageLength","BitsPerSample","Compression","PhotometricInterpretation","Orientation","SamplesPerPixel","PlanarConfiguration","YCbCrSubSampling","YCbCrPositioning","XResolution","YResolution","ResolutionUnit",
	// B.
	"StripOffsets","RowsPerStrip","StripByteCounts","JPEGInterchangeFormat","JPEGInterchangeFormatLength",
	// C.
	"TransferFunction","WhitePoint","PrimaryChromaticities","YCbCrCoefficients","ReferenceBlackWhite",
	// D.
	"DateTime","ImageDescription","Make","Model","Software","Artist","Copyright",
	// others
	"ExifIFDPointer","GPSInfoIFDPointer"
	};
// object data
protected long point; // offset of tag
protected long offset =0 ; // offset of values
protected int tag; // tag ID
protected String name; // tag name
protected String title; // tag title
protected int type; // type of values
protected int count; // count of values
protected Vector values; // vector of values
protected Vector strvalues; // vector of values as string
protected String strvalue; // string presentation of tags


/**
 * This method was created by a SmartGuide.
 * @param c long
 */
public void changeOffset(long c) {
	if(offset + c > 0)
		offset += c;
	return;
}
/**
 * This method was created by a SmartGuide.
 * @param c long
 */
public void changePoint(long c) {
	if(point + c > 0)
		point += c;
	return;
}
/**
 * This method was created by a SmartGuide.
 * @return long
 */
public static int estimateSize(int type, int count) {
int size = 0;
// set size of single value
	switch (type){
		case TYPE_BYTE:
		case TYPE_ASCII:
		case TYPE_UNDEFINED:
		size=1; // one byte
		break;
		
		case TYPE_SHORT:
		size=2; // 2 bytes
		break;
		
		case TYPE_LONG:
		case TYPE_SLONG:
		size=4; // 4 bytes
		break;
		
		case TYPE_RATIONAL:
		case TYPE_SRATIONAL:
		size=8; // 8 bytes
		break;
	}
// multiply by count
	return size * count;
}
/**
 * This method was created by a SmartGuide.
 * @return java.lang.String
 */
public String getName() {
	return name;
}
/**
 * This method returns field name of TIFF Rev.6.0 tag or Exif 2.0 private tag.
 * @return java.lang.String
 * @param t int
 */
public  String getName(int type) {
int t[] = getTypes();
String n[] = getNames();
	for(int i=0 ; i<t.length && i<n.length ; i++ )
		if( type == t[i]) // find tag ID value from int array
			return n[i]; // return matching tag name value
	return null;
}
/**
 * This method was created by a SmartGuide.
 * @return java.lang.String[]
 */
public  String[] getNames() {
	return TIFFTag.names;
}
/**
 * This method was created by a SmartGuide.
 * @return java.util.ResourceBundle
 */
public ResourceBundle getResourceBundle() {
	return ResourceBundle.getBundle("Exif.TIFFTagBundle");
}
/**
 * This method was created by a SmartGuide.
 * @return java.lang.String
 * @param key java.lang.String
 */
public String getResourceString(String key) {
ResourceBundle rb = getResourceBundle();
	try{
		return rb.getString(key); // try to get resource value for the key
	}catch(Exception e){
		return new String(""); // return null string when there is no resource entry for the key
	}
}
/**
 * This method was created by a SmartGuide.
 * @return java.lang.String
 */
public String getStringValue() {
	return strvalue;
}
/**
 * This method was created by a SmartGuide.
 * @return java.util.Vector
 */
public Vector getStringValues() {
	return strvalues;
}
/**
 * This method was created by a SmartGuide.
 * @return int
 */
public int getTagID() {
	return tag;
}
/**
 * This method was created by a SmartGuide.
 * @return java.lang.String
 */
public String getTitle() {
	return title;
}
/**
 * This method was created by a SmartGuide.
 * @return java.lang.String
 */
public String getTitle(String n) {
	return getResourceString(n); // get title string matching the tag name from resouce bundle 
}
/**
 * This method was created by a SmartGuide.
 * @return int[]
 */
public  int[] getTypes() {
	return TIFFTag.types;
}
/**
 * This method was created by a SmartGuide.
 * @return java.util.Vector
 */
public Vector getValues() {
	return values;
}
/**
 * This method was created by a SmartGuide.
 * @param args java.lang.String[]
 */
public static void main(String args[]) {
TIFFTag tag = new TIFFTag();
ResourceBundle rb = tag.getResourceBundle();
	for(int i=0 ; i<types.length && i<names.length ; i++ ){
//		System.out.println(Integer.toString(types[i]) + "," + names[i] + "," + rb.getString(names[i]));
		System.out.println("<TR><TD>"+Integer.toString(types[i]) + "</TD><TD>" + names[i] + "</TD><TD>" + rb.getString(names[i]) + "</TD></TR>");
	}
	return;
}
/**
 * This method was created by a SmartGuide.
 * @param file java.io.RandomAccessFile
 */
public void overwriteOffset(RandomAccessFile file) throws java.io.IOException {
	if(estimateSize(type, count) > 4){
		file.seek(HEADER_POINT + point + 8);
		writeDWord(file,(int)offset);
	}
	return;
}
/**
 * This method was created by a SmartGuide.
 * @param file java.io.RandomAccessFile
 * @param obj java.lang.Object
 */
public void overwriteValue(RandomAccessFile file, Object obj) throws java.io.IOException {
	switch(type){
		case TYPE_BYTE: //  1 byte : Integer
		file.write((byte)(((Integer)obj).intValue()));
		break;
		case TYPE_ASCII:
		break;
		case TYPE_SHORT: // 2 byte : Integer
		writeWord(file, ((Integer)obj).intValue());
		break;
		case TYPE_LONG: // 4 byte : Integer
		writeDWord(file, ((Integer)obj).intValue());
		break;
		case TYPE_RATIONAL: // 4 byte x 2 : Double
		{
		}
		break;
		case TYPE_UNDEFINED:
		file.write((byte)(((Byte)obj).intValue()));
		break;
		case TYPE_SLONG: // 4 byte (signed) : int
		writeSignedDWord(file, ((Integer)obj).intValue());
		break;
		case TYPE_SRATIONAL: // 4 byte (signed) x 2 : Double
		{
		}
		break;
	}
	return;
}
/**
 * This method was created by a SmartGuide.
 * @param file java.io.RandomAccessFile
 */
public void overwriteValues(RandomAccessFile file) throws java.io.IOException {
	if(estimateSize(type, count) >4){
		file.seek(HEADER_POINT + offset);
	}else{
		file.seek(HEADER_POINT + point + 8);
	}

	switch(type){
		case TYPE_ASCII: // write ascii characters
		{
		int i = 0;
			for(Enumeration e = values.elements(); e.hasMoreElements() && i<count ;){
			String str = (String)e.nextElement();
				for(int j=0 ; j<str.length() && i<count ; j++, i++){
					file.write((byte)str.charAt(j));
				}
				if(e.hasMoreElements()){
					file.write((byte)STRING_TERMINATOR);
					i+=1;
				}
			}
			for(; i<count ; i++) // fill rest space by null characters
				file.write((byte)STRING_TERMINATOR);
		}
		break;
		
		case TYPE_UNDEFINED:
		case TYPE_BYTE:
		case TYPE_SHORT:
		case TYPE_LONG:
		case TYPE_RATIONAL:
		case TYPE_SLONG:
		case TYPE_SRATIONAL: // read <count> number of objects
		{
		Enumeration e = values.elements();
			for(int i=0 ; i<count && e.hasMoreElements() ; i++){
				overwriteValue(file, e.nextElement());
			}
		}
		break;
	}
	return;
}
/**
 * This method was created by a SmartGuide.
 * @return int
 * @param file java.io.RandomAccessFile
 */
public static int readDWord(RandomAccessFile file) throws java.io.IOException{
int w1,w2;
// read 2 words (4 bytes)
	w1 = readWord(file);
	w2 = readWord(file);
// make double word value
	if(LITTLE_ENDIAN)
		return w2 * BYTE_BOUNDARY  * BYTE_BOUNDARY + w1;
	else
		return (int)w1 * (int)BYTE_BOUNDARY  * (int)BYTE_BOUNDARY + (int)w2;
}
/**
 * This method reads an entire tag from a file.
 * @param file java.io.RandomAccessFile
 * @param p long
 */
public void readFromFile (RandomAccessFile file, long p )  throws java.io.IOException {
	file.seek(HEADER_POINT + p);
// set file pointer
	point = p;
// read tag (2 bytes)
	tag = readWord(file);
// set name
	name = getName(tag);
// set title
	title = getTitle(name);
// read type (2bytes)
	type = readWord(file);
// read count (4 bytes)
	count = readDWord(file);
// estimate size
int size = estimateSize(type, count);
	if(size > 4){ // read offset value if size is larger than 4 byte
	// read offset (4 bytes)
		offset = readDWord(file);
		file.seek(HEADER_POINT + offset);
	}
	// read values
	readValues(file);
	// set string value
	setStringValue();
//	System.out.println(Integer.toString(tag) + " , " + title +" , " + strvalues + " , " +strvalue);
	return;
}
/**
 * This method was created by a SmartGuide.
 * @return int
 * @param file java.io.RandomAccessFile
 */
public static int readSignedDWord (RandomAccessFile file) throws java.io.IOException {
int w1,w2;
// read 2 words (4 bytes)
	w1 = readWord(file);
	w2 = readWord(file);
// make signed double word value
	if(LITTLE_ENDIAN){
		if(w2 >= BYTE_BOUNDARY / 2 * BYTE_BOUNDARY)
			w2 = -w2;
		return w2 * BYTE_BOUNDARY  * BYTE_BOUNDARY + w1;
	}else{
		if(w1 >= BYTE_BOUNDARY / 2 * BYTE_BOUNDARY)
			w1 = -w1;
		return w1 * BYTE_BOUNDARY  * BYTE_BOUNDARY + w2;
	}
}
/**
 * This method reads a tag content value from a file and store the value to the object vector.
 * This method also store the value as a string value to the string vector.
 * @param file java.io.RandomAccessFile
 * @param objs java.util.Vector
 * @param strs java.util.Vector
 */
public void readValue(RandomAccessFile file, Vector objs, Vector strs) throws java.io.IOException {
Object obj = null;
String str = null;
	switch(type){
		case TYPE_BYTE: //  1 byte
			obj = new Integer(file.readUnsignedByte());
			str = obj.toString();
		break;
		case TYPE_ASCII:
		break;
		case TYPE_SHORT: // 2 byte
			obj = new Integer(readWord(file));
			str = obj.toString();
		break;
		case TYPE_LONG: // 4 byte
			obj = new Integer(readDWord(file));
			str = obj.toString();
		break;
		case TYPE_RATIONAL: // 4 byte x 2
		{
		int l1 = readDWord(file);
		int l2 = readDWord(file);
			obj = new Double((double)l1 / (double)l2);
			if(l1 == 0)
				str = "0";
			else if(l2 == 1)
				str = Integer.toString(l1);
			else
				str = Integer.toString(l1) + "/" + Integer.toString(l2);
		}
		break;
		case TYPE_UNDEFINED:
		break;
		case TYPE_SLONG: // 4 byte (signed)
			obj = new Integer(readSignedDWord(file));
			str = obj.toString();
		break;
		case TYPE_SRATIONAL: // 4 byte (signed) x 2
		{
		int l1 = readSignedDWord(file);
		int l2 = readSignedDWord(file);
			obj = new Double((double)l1 / (double)l2);
			if(l1 == 0)
				str = "0";
			else if(l2 == 1)
				str = Integer.toString(l1);
			else
				str = Integer.toString(l1) + "/" + Integer.toString(l2);
		}
		break;
	}
	if(obj != null)
		objs.addElement(obj);
	if(str != null);
		strs.addElement(str);
	return;
}
/**
 * This method read tag content values from a file.
 * @param file java.io.RandomAccessFile
 */
public void readValues(RandomAccessFile file) throws java.io.IOException {
	values = new Vector();
	strvalues = new Vector();
	switch(type){
		case TYPE_ASCII: // read <count> number of ASCII characters
		{
		String str = new String("");
			for(int i=0 ; i< count ; i++){
			char	c = (char)file.readUnsignedByte();
				if(c == STRING_TERMINATOR){
					values.addElement((Object)str);
					strvalues.addElement((Object)str);	
					str = new String("");
				}else
					str += c;
			}
			if( !str.equals("") ){
				values.addElement((Object)str);
				strvalues.addElement((Object)str);
			}
		}
		break;
		
		case TYPE_UNDEFINED:
		{
		String str = new String("");
			for(int i=0 ; i< count ; i++){
			int b = file.readUnsignedByte();
				str += (char)b;
				values.addElement(new Byte((byte)b));
			}
			if(!str.equals(""))
				strvalues.addElement(str);
		}
		break;
		
		case TYPE_BYTE:
		case TYPE_SHORT:
		case TYPE_LONG:
		case TYPE_RATIONAL:
		case TYPE_SLONG:
		case TYPE_SRATIONAL: // read <count> number of objects
		for(int i=0 ; i<count ; i++){
			readValue(file, values, strvalues);
		}
		break;
	}
	return;
}
/**
 * This method was created by a SmartGuide.
 * @return int
 * @param file java.io.RandomAccessFile
 */
public static int readWord(RandomAccessFile file) throws java.io.IOException {
int word;
int b1,b2;
// read 1 word (2 bytes)
	b1 = file.readUnsignedByte();
	b2 = file.readUnsignedByte();
// make word value
	if(LITTLE_ENDIAN)
		word = b2 * BYTE_BOUNDARY + b1;
	else
		word = b1 * BYTE_BOUNDARY + b2;
	return word;
}
/**
 * This method was created by a SmartGuide.
 * @param p long
 */
public static void setHeaderPoint(long p) {
	HEADER_POINT=p;
	return;
}
/**
 * This method was created by a SmartGuide.
 * @param e boolean
 */
public static  void setLittleEndian(boolean e) {
	LITTLE_ENDIAN=e;
	return;
}
/**
 * This method sets the string value suitable for each tag.
 */
public void setStringValue() {
	switch(tag){
		case 256: // imageWidth
		case 257: // imageHeight
		case 258: // BitsPerSample
		case 277: // SamplesPerPixel
		case 282: // XResolution
		case 283: // YResolution
		case 273: // StripOffsets
		case 278: // RowsPerStrip
		case 279: // StripByteCounts
		case 513: // JPEGInterchangeFormat
		case 514: // JPEGInterchangeFormatLength
		case 301: // TransferFunction
		case 318: // WhitePoint
		case 319: // PrimaryChromaticities
		case 529: // YCbCrCoefficients
		case 532: // ReferenceBlackWhite
		case 306: // DateTime
		case 270: // ImageDescription
		case 271: // Make
		case 272: // Model
		case 305: // Software
		case 315: // Artist
		case 33432: // Copyright
		strvalue = vectorToString(strvalues);
		break;
		
		case 259: // Compression
		case 262: // PhotometricInterpretation
		case 274: // Orientation
		case 284: // PlanarConfiguration
		case 530: // YCbCrSubSampling
		case 531: // YCbCrPositioning
		case 296: // ResolutionUnit
		{
		String s = vectorToString(strvalues);
			strvalue = getResourceString(name+"_"+s);
		}
		break;		

		default:
		strvalue = vectorToString(strvalues);
		break;
	}
	return;
}
/**
 * This method returns a string created from an Object vector.
 * This method uses "," as a separator.
 * @return java.lang.String
 * @param v java.util.Vector
 */
public String vectorObjectToString(Vector v) {
String str = new String("");
	for(Enumeration e = v.elements(); e.hasMoreElements();){
		str += e.nextElement().toString();
		if(e.hasMoreElements())
			str += ", ";
	}
	return str;
}
/**
 * This method returns a string created by a string vector.
 * This method uses "," as a separator.
 * @return java.lang.String
 * @param v java.util.Vector
 */
public String vectorToString(Vector v) {
String str = new String("");
	for(Enumeration e = v.elements(); e.hasMoreElements();){
		str += e.nextElement().toString();
		if(e.hasMoreElements())
			str += ", ";
	}
	return str;
}
/**
 * This method was created by a SmartGuide.
 * @param file java.io.RandomAccessFile
 * @param l long
 */
public static void writeDWord(RandomAccessFile file, int l) throws java.io.IOException {
int b1 = l / (BYTE_BOUNDARY * BYTE_BOUNDARY);
int b2 =l - (b1 * BYTE_BOUNDARY * BYTE_BOUNDARY);
	if(LITTLE_ENDIAN){
		writeWord(file,b2);
		writeWord(file,b1);
	}else{
		writeWord(file,b1);
		writeWord(file,b2);
	}
	return;
}
/**
 * This method was created by a SmartGuide.
 * @param file java.io.RandomAccessFile
 */
public static void writeHeader(RandomAccessFile file) throws java.io.IOException {
	if(LITTLE_ENDIAN){
		file.write((byte)0x49);
		file.write((byte)0x49);
	}else{
		file.write((byte)0x4d);
		file.write((byte)0x4d);
	}
	
	writeWord(file, (int)0x002a);
	writeDWord(file, (int)0x00000008);
	
	return;
}
/**
 * This method was created by a SmartGuide.
 * @param file java.io.RandomAccessFile
 * @param l int
 * @exception java.io.IOException The exception description.
 */
public static void writeSignedDWord(RandomAccessFile file, int l) throws IOException {
	if( l<0)
		l += BYTE_BOUNDARY * BYTE_BOUNDARY / 2;
	writeDWord(file, l);
	return;
}
/**
 * This method was created by a SmartGuide.
 * @param file java.io.RandomAccessFile
 * @param w int
 */
public static void writeWord(java.io.RandomAccessFile file, int w) throws java.io.IOException {
byte b1 = (byte)(w / BYTE_BOUNDARY);
byte b2 = (byte)(w - (int)b1 * BYTE_BOUNDARY); 
	if(LITTLE_ENDIAN){
		file.write(b2);
		file.write(b1);
	}else{
		file.write(b1);
		file.write(b2);
	}
	return;
}
}