package Share;

import java.util.*;
import java.io.*;
import java.text.*;
/**
 * This class extends File capabilities
 * 
 */

public class FileHandler {
/**
 * This method was created by a SmartGuide.
 * @return java.lang.String
 * @param filename java.lang.String
 */
public String trimSuffix(String filename, String suffix) {
	return filename.substring(0,filename.length()-suffix.length());
}

/**
 * @return java.lang.String[]
 * @param dir java.io.File
 */
public String[] getSortedDirectoryList(File dir) {
	return getSortedList(dir.list());
}

/**
 * @return java.lang.String[]
 * @param dir java.io.File
 * @param 
 */
public String[] getSortedDirectoryList(File dir, FilenameFilter filter) {
	return getSortedList(dir.list(filter));
}


/*
 * @return java.lang.String[]
 * @ param names java.lang.String
 */
public String[] getSortedList(String[] names) {
Collator coll = Collator.getInstance();
String[] ret = new String[names.length];
Vector list = new Vector();
	for(int i=0 ; i<names.length ; i++){
		list.addElement(names[i]);
	}
	Collections.sort(list, coll);
	list.copyInto(ret);
	return ret;
}

/*
 * @return java.lang.String[]
 * @param dir java.io.File
 */
public File[] getSortedDirectories(File dir) {
//Collator coll = Collator.getInstance();
File files[] = dir.listFiles();
Vector list = new Vector();
	for(int i=0 ; i<files.length ; i++){
		if(files[i].isDirectory())
			list.addElement(files[i]);
	}
	Collections.sort(list, new FileComparator());
	list.copyInto(files);
	return files;
}


}