package Share;

import java.awt.*;
import java.awt.image.*;
import java.io.*;
import com.sun.image.codec.jpeg.*;


public class JPEGConverter implements ImageObserver
{
public int width, height;
public float quality;
protected boolean drawn = false;

public static void main(String[] args){
   if(args.length >= 4){
      try {
         JPEGConverter jc = new JPEGConverter();
         jc.width = Integer.parseInt(args[2]);
         jc.height = Integer.parseInt(args[3]);
         if(args.length >= 5){
            jc.quality = Float.parseFloat(args[4]);
         }else{
            jc.quality = 0.9f;
         }
         jc.convertFile(args[0], args[1]);
      }catch (Exception e){
         e.printStackTrace(System.err);
      }
   }
   System.exit(0);
}

public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height){
    if((infoflags & ImageObserver.ERROR) !=0 || (infoflags & ImageObserver.ABORT) != 0){
        drawn = true;
        return false;
    }
    if((infoflags & ImageObserver.ALLBITS) != 0){
        drawn = true;
        return false;
    }
    return true;
}

public void convertFile(String infile, String outfile) throws Exception{
    // Create image.
    BufferedImage bimage = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
    Graphics g = bimage.getGraphics();

Toolkit tk = Toolkit.getDefaultToolkit();
Image image = tk.getImage(infile);
    drawn = false;
    tk.prepareImage(image,-1,-1,this);
    while(drawn == false){
        java.lang.Thread.sleep(100);
    }
/*
    try{
    MediaTracker mt = new MediaTracker(this);
        mt.addImage(image,0);
        mt.waitForAll();
    }catch(Exception e){
        e.printStackTrace();
    }
*/

    drawn = false;
    if(! g.drawImage(image,0,0,width,height,this)){
        while(drawn == false){
            java.lang.Thread.sleep(100);
        }
    }

    File oFile = new File(outfile);
    File oDir = new File(oFile.getParent());
    if(! oDir.exists()){
       oDir.mkdirs();
    }

    // Open output file.
    OutputStream out = new FileOutputStream(outfile);

    // Create jpeg encoder.
    JPEGImageEncoder encoder =
      JPEGCodec.createJPEGEncoder(out);

    // Set quality.
    JPEGEncodeParam encodeParam =
    encoder.getDefaultJPEGEncodeParam(bimage);
    encodeParam.setQuality(quality, false);

    // Encode.
    encoder.encode(bimage, encodeParam);

    // Close output file.
    out.close();
  }
}