package Share;





import java.util.*;

import java.io.*;

/**

 * This class reads property values from an input stream.

 * 

 */

public class PropertyReader {

protected static String nextLine(BufferedReader br) {

String line = null;

	try{

		line = br.readLine();

		if(line == null)

			return null;

		line = line.trim();

		while(line != null && (line.startsWith("#") || line.length() == 0)){

			line = br.readLine();

			if(line == null)

				return null;

			line = line.trim();

		}

	}catch(IOException e){return null;

	}catch(NullPointerException e){return null;}

	return line;

}

/**

 * This method was created by a SmartGuide.

 * @return java.lang.String[][]

 * @param is java.io.InputStream

 */

public static String[][] readFormat(InputStream is) {

//DataInputStream br = new DataInputStream(is);

BufferedReader br = new BufferedReader(new InputStreamReader(is));

Vector v = new Vector();

String line = null;

	while(true){

		line = nextLine(br);

		if(line == null)

			break;

		v.addElement(readFormat(line,"|"));

	}

String format[][] = new String[v.size()][];

	v.copyInto(format);

	return format;

}

/**

 * This method was created by a SmartGuide.

 * @return UndefinedObject[]

 * @param str java.lang.String

 */

public static String[] readFormat(String str, String del) {

StringTokenizer t= new StringTokenizer(str,del,true);

String format[];

Vector v = new Vector();

	try{

		if(!t.hasMoreTokens())

			v.addElement(str);

	boolean delim = true;

		while(t.hasMoreTokens()){

		String buf = t.nextToken().trim();

			if(buf.length() == 1 && del.indexOf(buf) >= 0){

				if(delim)

					v.addElement(new String(""));

				delim = true;

			}else{

				v.addElement(buf);

				delim = false;

			}

		}

		if(delim)

			v.addElement(new String(""));

	}catch(NoSuchElementException e){

		System.out.println("NoSuchElementException");

	}

	format = new String[v.size()];

	v.copyInto(format);



	return format;

}

/**

 * This method was created by a SmartGuide.

 * @return java.lang.String[][]

 * @param file java.io.File

 */

public String[][] readFormatFile(File file) {

	if(file.exists())

		return readFormatFile(file.getPath());

	return null;

}

/**

 * This method was created by a SmartGuide.

 * @return java.lang.String[][]

 * @param filename java.lang.String

 */

public String[][] readFormatFile(String filename) {

InputStream is;

Share.StreamHandler fr = new Share.StreamHandler();

String format[][] = null;

	if((is = fr.openStream(filename)) != null){

		format = readFormat(is);

		fr.closeStream(is);

	}

	return format;

}

}