package Share;





import java.applet.*;

import java.io.*;

import java.util.Vector;

import java.util.*;

/**

 * This class reads resource values from an input stream or a file.

 *

 */

public class ResourceReader {

protected static Applet applet = null;

protected Hashtable rcs = new Hashtable();





public ResourceReader(){

}

public String getValue(String n){

	if(rcs.containsKey(n))

		return (String)rcs.get(n);

	if(applet != null)

		return applet.getParameter(n);

	return null;

}

protected String nextLine(BufferedReader br) {

String line = null;

	try{

		line = br.readLine().trim();

		while(line != null && (line.startsWith("#") || line.length() == 0)){

			line = br.readLine().trim();

		}

	}catch(IOException e){return null;

	}catch(NullPointerException e){return null;}

	return line;

}

/**

 * This method was created by a SmartGuide.

 * @param file java.io.File

 */

public void readResourceFile(File file) {

InputStream is;

	if(file.exists()){

		readResourceFile(file.getPath());

	}

	return;

}

public void readResourceFile(String filename){

InputStream is;

Share.StreamHandler fr = new Share.StreamHandler();

	if(!files.containsKey(filename) && (is = fr.openStream(filename)) != null){

		readResources(is);

		fr.closeStream(is);

		files.put(filename, filename);

	}

	return;

}

/**

 * This method was created by a SmartGuide.

 * @param is java.io.InputStream

 */

public void readResources(InputStream is) {

//DataInputStream br = new DataInputStream(is);

BufferedReader br = new BufferedReader(new InputStreamReader(is));

String line = null;

	while(true){

		line = nextLine(br);

		if(line == null)

			break;

	StringTokenizer tk = new StringTokenizer(line,"=");

		if(tk.hasMoreTokens()){

		String name = tk.nextToken().trim();

			if(tk.hasMoreTokens()){

			String value = tk.nextToken().trim();

				// System.out.println(name + " = " +value);

				rcs.put(name,value);

			}else{ // only one entry -> filename

				readResourceFile(name);

			}

		}	

	}

	return;

}

/**

 * This method was created by a SmartGuide.

 * @param a java.applet.Applet

 */

public static void setApplet(Applet a) {

	applet = a;

	return;

}

protected Hashtable files = new Hashtable();}